/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.scheduler;

import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import junit.framework.TestCase;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.scheduler.JobScheduler;
import org.apache.activemq.broker.scheduler.SchedulerBroker;
import org.apache.activemq.util.IOHelper;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=BlockJUnit4ClassRunner.class)
public class JmsCronSchedulerTest
extends EmbeddedBrokerTestSupport {
    @Rule
    public TestName testName = new TestName();
    private static final Logger LOG = LoggerFactory.getLogger(JmsCronSchedulerTest.class);

    @Test
    public void testSimulatenousCron() throws Exception {
        int COUNT = 10;
        final AtomicInteger count = new AtomicInteger();
        Connection connection = this.createConnection();
        Session session = connection.createSession(false, 1);
        MessageConsumer consumer = session.createConsumer((Destination)this.destination);
        final CountDownLatch latch = new CountDownLatch(10);
        consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                count.incrementAndGet();
                latch.countDown();
                TestCase.assertTrue((boolean)(message instanceof TextMessage));
                TextMessage tm = (TextMessage)message;
                try {
                    LOG.info("Received [{}] count: {} ", (Object)tm.getText(), (Object)count.get());
                }
                catch (JMSException e) {
                    LOG.error("Unexpected exception in onMessage", (Throwable)e);
                    TestCase.fail((String)("Unexpected exception in onMessage: " + e.getMessage()));
                }
            }
        });
        connection.start();
        for (int i = 0; i < 10; ++i) {
            MessageProducer producer = session.createProducer((Destination)this.destination);
            TextMessage message = session.createTextMessage("test msg " + i);
            message.setStringProperty("AMQ_SCHEDULED_CRON", "* * * * *");
            producer.send((Message)message);
            LOG.info("Message {} sent at {}", (Object)i, (Object)new Date().toString());
            producer.close();
            Thread.sleep(2000L);
        }
        SchedulerBroker sb = (SchedulerBroker)this.broker.getBroker().getAdaptor(SchedulerBroker.class);
        JobScheduler js = sb.getJobScheduler();
        List list = js.getAllJobs();
        JmsCronSchedulerTest.assertEquals((int)10, (int)list.size());
        latch.await(2L, TimeUnit.MINUTES);
        JmsCronSchedulerTest.assertEquals((int)10, (int)count.get());
    }

    @Test
    public void testCronScheduleWithTtlSet() throws Exception {
        Connection connection = this.createConnection();
        Session session = connection.createSession(false, 1);
        MessageConsumer consumer = session.createConsumer((Destination)this.destination);
        connection.start();
        MessageProducer producer = session.createProducer((Destination)this.destination);
        producer.setTimeToLive(TimeUnit.MINUTES.toMillis(1L));
        TextMessage message = session.createTextMessage("test msg ");
        message.setStringProperty("AMQ_SCHEDULED_CRON", "* * * * *");
        producer.send((Message)message);
        producer.close();
        Thread.sleep(TimeUnit.MINUTES.toMillis(2L));
        JmsCronSchedulerTest.assertNotNull((Object)consumer.receiveNoWait());
        JmsCronSchedulerTest.assertNull((Object)consumer.receiveNoWait());
    }

    @Override
    @Before
    public void setUp() throws Exception {
        LOG.info("Starting test {}", (Object)this.testName.getMethodName());
        this.bindAddress = "vm://localhost";
        super.setUp();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Override
    protected BrokerService createBroker() throws Exception {
        return this.createBroker(true);
    }

    protected BrokerService createBroker(boolean delete) throws Exception {
        File schedulerDirectory = new File("target/scheduler");
        if (delete) {
            IOHelper.mkdirs((File)schedulerDirectory);
            IOHelper.deleteChildren((File)schedulerDirectory);
        }
        BrokerService answer = new BrokerService();
        answer.setPersistent(true);
        answer.getManagementContext().setCreateConnector(false);
        answer.setDeleteAllMessagesOnStartup(true);
        answer.setDataDirectory("target");
        answer.setSchedulerDirectoryFile(schedulerDirectory);
        answer.setSchedulerSupport(true);
        answer.setUseJmx(false);
        answer.addConnector(this.bindAddress);
        return answer;
    }
}

