/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.TransportConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ2751Test
extends EmbeddedBrokerTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(AMQ2751Test.class);
    private static String clientIdPrefix = "consumer";
    private static String queueName = "FOO";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRecoverRedelivery() throws Exception {
        final CountDownLatch redelivery = new CountDownLatch(6);
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("failover:(" + ((TransportConnector)this.broker.getTransportConnectors().get(0)).getConnectUri() + ")");
        try {
            Connection connection = factory.createConnection();
            String clientId = clientIdPrefix;
            connection.setClientID(clientId);
            final Session session = connection.createSession(false, 2);
            Queue queue = session.createQueue(queueName);
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            consumer.setMessageListener(new MessageListener(){

                public void onMessage(Message message) {
                    try {
                        LOG.info("Got message: " + message.getJMSMessageID());
                        if (message.getJMSRedelivered()) {
                            LOG.info("It's a redelivery.");
                            redelivery.countDown();
                        }
                        LOG.info("calling recover() on the session to force redelivery.");
                        session.recover();
                    }
                    catch (JMSException e) {
                        e.printStackTrace();
                    }
                }
            });
            System.out.println("Created queue consumer with clientId " + clientId);
            connection.start();
            MessageProducer producer = session.createProducer((Destination)queue);
            producer.send((Message)session.createTextMessage("test"));
            AMQ2751Test.assertTrue((String)"we got 6 redeliveries", (boolean)redelivery.await(20L, TimeUnit.SECONDS));
        }
        finally {
            this.broker.stop();
        }
    }

    @Override
    protected void setUp() throws Exception {
        this.bindAddress = "tcp://localhost:0";
        super.setUp();
    }
}

