/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import javax.jms.Connection;
import javax.jms.InvalidDestinationException;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ4671Test {
    private static final transient Logger LOG = LoggerFactory.getLogger(AMQ4671Test.class);
    private static BrokerService brokerService;
    private static String BROKER_ADDRESS;
    private String connectionUri;

    @Before
    public void setUp() throws Exception {
        brokerService = new BrokerService();
        brokerService.setPersistent(false);
        brokerService.setUseJmx(true);
        brokerService.setDeleteAllMessagesOnStartup(true);
        this.connectionUri = brokerService.addConnector(BROKER_ADDRESS).getPublishableConnectString();
        this.connectionUri = this.connectionUri + "?trace=true";
        brokerService.start();
        brokerService.waitUntilStarted();
    }

    @After
    public void tearDown() throws Exception {
        brokerService.stop();
        brokerService.waitUntilStopped();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNonDurableSubscriberInvalidUnsubscribe() throws Exception {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(this.connectionUri);
        Connection connection = connectionFactory.createConnection();
        connection.setClientID(this.getClass().getName());
        connection.start();
        try {
            Session ts = connection.createSession(false, 1);
            try {
                ts.unsubscribe("invalid-subscription-name");
                Assert.fail((String)"this should fail");
            }
            catch (InvalidDestinationException e) {
                LOG.info("Test caught correct invalid destination exception");
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    static {
        BROKER_ADDRESS = "tcp://localhost:0";
    }
}

