/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.failover;

import java.net.URI;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.transport.failover.FailoverTransport;

public class FailoverTimeoutTest
extends TestCase {
    private static final String QUEUE_NAME = "test.failovertimeout";
    BrokerService bs;
    URI tcpUri;

    public void setUp() throws Exception {
        this.bs = new BrokerService();
        this.bs.setUseJmx(false);
        this.bs.addConnector("tcp://localhost:0");
        this.bs.start();
        this.tcpUri = ((TransportConnector)this.bs.getTransportConnectors().get(0)).getConnectUri();
    }

    public void tearDown() throws Exception {
        if (this.bs != null) {
            this.bs.stop();
        }
    }

    public void testTimeout() throws Exception {
        long timeout = 1000L;
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("failover:(" + this.tcpUri + ")?timeout=" + timeout + "&useExponentialBackOff=false");
        Connection connection = cf.createConnection();
        Session session = connection.createSession(false, 1);
        MessageProducer producer = session.createProducer((Destination)session.createQueue(QUEUE_NAME));
        TextMessage message = session.createTextMessage("Test message");
        producer.send((Message)message);
        this.bs.stop();
        try {
            producer.send((Message)message);
        }
        catch (JMSException jmse) {
            FailoverTimeoutTest.assertEquals((String)("Failover timeout of " + timeout + " ms reached."), (String)jmse.getMessage());
        }
        this.bs = new BrokerService();
        this.bs.setUseJmx(false);
        this.bs.addConnector(this.tcpUri);
        this.bs.start();
        this.bs.waitUntilStarted();
        producer.send((Message)message);
        this.bs.stop();
    }

    public void testUpdateUris() throws Exception {
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("failover:(" + this.tcpUri + ")?useExponentialBackOff=false");
        ActiveMQConnection connection = (ActiveMQConnection)cf.createConnection();
        connection.start();
        FailoverTransport failoverTransport = (FailoverTransport)connection.getTransport().narrow(FailoverTransport.class);
        URI[] bunchOfUnknownAndOneKnown = new URI[]{new URI("tcp://unknownHost:" + this.tcpUri.getPort()), new URI("tcp://unknownHost2:" + this.tcpUri.getPort()), new URI("tcp://localhost:2222")};
        failoverTransport.add(false, bunchOfUnknownAndOneKnown);
    }
}

