/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.ft;

import java.io.File;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.JmsTopicSendReceiveWithTwoConnectionsTest;
import org.apache.activemq.advisory.AdvisorySupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.xbean.BrokerFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public abstract class QueueMasterSlaveTestSupport
extends JmsTopicSendReceiveWithTwoConnectionsTest {
    private static final transient Logger LOG = LoggerFactory.getLogger(QueueMasterSlaveTestSupport.class);
    protected BrokerService master;
    protected AtomicReference<BrokerService> slave = new AtomicReference();
    protected CountDownLatch slaveStarted = new CountDownLatch(1);
    protected int inflightMessageCount;
    protected int failureCount = 50;
    protected String uriString = "failover://(tcp://localhost:62001,tcp://localhost:62002)?randomize=false&useExponentialBackOff=false";

    @Override
    protected void setUp() throws Exception {
        this.setMaxTestTime(TimeUnit.MINUTES.toMillis(10L));
        this.setAutoFail(true);
        if (System.getProperty("basedir") == null) {
            File file = new File(".");
            System.setProperty("basedir", file.getAbsolutePath());
        }
        this.messageCount = 500;
        this.failureCount = this.messageCount / 2;
        this.topic = this.isTopic();
        this.createMaster();
        this.createSlave();
        Thread.sleep(1000L);
        super.setUp();
    }

    protected String getSlaveXml() {
        return "org/apache/activemq/broker/ft/slave.xml";
    }

    protected String getMasterXml() {
        return "org/apache/activemq/broker/ft/master.xml";
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.master.stop();
        this.master.waitUntilStopped();
        this.slaveStarted.await(5L, TimeUnit.SECONDS);
        BrokerService brokerService = this.slave.get();
        if (brokerService != null) {
            brokerService.stop();
        }
        this.master.stop();
    }

    @Override
    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory(this.uriString);
    }

    @Override
    protected void messageSent() throws Exception {
        if (++this.inflightMessageCount == this.failureCount) {
            Thread.sleep(1000L);
            LOG.error("MASTER STOPPED!@!!!!");
            this.master.stop();
        }
    }

    protected boolean isTopic() {
        return false;
    }

    protected void createMaster() throws Exception {
        BrokerFactoryBean brokerFactory = new BrokerFactoryBean((Resource)new ClassPathResource(this.getMasterXml()));
        brokerFactory.afterPropertiesSet();
        this.master = brokerFactory.getBroker();
        this.master.start();
    }

    protected void createSlave() throws Exception {
        BrokerFactoryBean brokerFactory = new BrokerFactoryBean((Resource)new ClassPathResource(this.getSlaveXml()));
        brokerFactory.afterPropertiesSet();
        BrokerService broker = brokerFactory.getBroker();
        broker.start();
        this.slave.set(broker);
        this.slaveStarted.countDown();
    }

    public void testVirtualTopicFailover() throws Exception {
        MessageConsumer qConsumer = this.session.createConsumer((Destination)new ActiveMQQueue("Consumer.A.VirtualTopic.TA1"));
        QueueMasterSlaveTestSupport.assertNull((String)"No message there yet", (Object)qConsumer.receive(1000L));
        qConsumer.close();
        QueueMasterSlaveTestSupport.assertTrue((!this.master.isSlave() ? 1 : 0) != 0);
        this.master.stop();
        QueueMasterSlaveTestSupport.assertTrue((String)"slave started", (boolean)this.slaveStarted.await(15L, TimeUnit.SECONDS));
        QueueMasterSlaveTestSupport.assertTrue((!this.slave.get().isSlave() ? 1 : 0) != 0);
        String text = "ForUWhenSlaveKicksIn";
        this.producer.send((Destination)new ActiveMQTopic("VirtualTopic.TA1"), (Message)this.session.createTextMessage("ForUWhenSlaveKicksIn"));
        qConsumer = this.session.createConsumer((Destination)new ActiveMQQueue("Consumer.A.VirtualTopic.TA1"));
        Message message = qConsumer.receive(4000L);
        QueueMasterSlaveTestSupport.assertNotNull((String)"Get message after failover", (Object)message);
        QueueMasterSlaveTestSupport.assertEquals((String)"correct message", (String)"ForUWhenSlaveKicksIn", (String)((TextMessage)message).getText());
    }

    public void testAdvisory() throws Exception {
        MessageConsumer advConsumer = this.session.createConsumer((Destination)AdvisorySupport.getMasterBrokerAdvisoryTopic());
        this.master.stop();
        QueueMasterSlaveTestSupport.assertTrue((String)"slave started", (boolean)this.slaveStarted.await(15L, TimeUnit.SECONDS));
        LOG.info("slave started");
        Message advisoryMessage = advConsumer.receive(5000L);
        LOG.info("received " + advisoryMessage);
        QueueMasterSlaveTestSupport.assertNotNull((String)"Didn't received advisory", (Object)advisoryMessage);
    }
}

