/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.policy;

import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.policy.AbortSlowConsumer2Test;
import org.apache.activemq.broker.region.policy.AbortSlowAckConsumerStrategy;
import org.apache.activemq.broker.region.policy.AbortSlowConsumerStrategy;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.broker.region.policy.SlowConsumerStrategy;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class AbortSlowAckConsumer2Test
extends AbortSlowConsumer2Test {
    private static final Logger LOG = LoggerFactory.getLogger(AbortSlowAckConsumer2Test.class);
    protected long maxTimeSinceLastAck = 5000L;

    public AbortSlowAckConsumer2Test(Boolean topic) {
        super(topic);
    }

    @Override
    protected AbortSlowConsumerStrategy createSlowConsumerStrategy() {
        return new AbortSlowConsumerStrategy();
    }

    @Override
    protected BrokerService createBroker() throws Exception {
        BrokerService broker = super.createBroker();
        PolicyEntry policy = new PolicyEntry();
        AbortSlowAckConsumerStrategy strategy = new AbortSlowAckConsumerStrategy();
        strategy.setAbortConnection(this.abortConnection);
        strategy.setCheckPeriod(this.checkPeriod);
        strategy.setMaxSlowDuration(this.maxSlowDuration);
        strategy.setMaxTimeSinceLastAck(this.maxTimeSinceLastAck);
        policy.setSlowConsumerStrategy((SlowConsumerStrategy)strategy);
        policy.setQueuePrefetch(10);
        policy.setTopicPrefetch(10);
        PolicyMap pMap = new PolicyMap();
        pMap.setDefaultEntry(policy);
        broker.setDestinationPolicy(pMap);
        return broker;
    }

    @Override
    protected ConnectionFactory createConnectionFactory() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://localhost");
        factory.getPrefetchPolicy().setAll(1);
        return factory;
    }
}

