/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.policy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.ExceptionListener;
import org.apache.activemq.broker.policy.AbortSlowConsumerBase;
import org.apache.activemq.util.MessageIdList;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class AbortSlowConsumer2Test
extends AbortSlowConsumerBase {
    private static final Logger LOG = LoggerFactory.getLogger(AbortSlowConsumer2Test.class);

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> getTestParameters() {
        Boolean[] booleanValues;
        ArrayList<Object[]> testParameters = new ArrayList<Object[]>();
        for (Boolean topic : booleanValues = new Boolean[]{Boolean.TRUE, Boolean.FALSE}) {
            Boolean[] value = new Boolean[]{topic};
            testParameters.add(value);
        }
        return testParameters;
    }

    public AbortSlowConsumer2Test(Boolean isTopic) {
        this.topic = isTopic;
    }

    @Test(timeout=60000L)
    public void testLittleSlowConsumerIsNotAborted() throws Exception {
        this.startConsumers(this.destination);
        Map.Entry consumertoAbort = this.consumers.entrySet().iterator().next();
        ((MessageIdList)((Object)consumertoAbort.getValue())).setProcessingDelay(500L);
        for (Connection c : this.connections) {
            c.setExceptionListener((ExceptionListener)this);
        }
        this.startProducers(this.destination, 12);
        this.allMessagesList.waitForMessagesToArrive(10);
        this.allMessagesList.assertAtLeastMessagesReceived(10);
    }
}

