/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.AutoFailTestSupport;
import org.apache.activemq.broker.BrokerPlugin;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.util.LoggingBrokerPlugin;
import org.apache.activemq.util.DefaultTestAppender;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;

public class AMQ3779Test
extends AutoFailTestSupport {
    private static final Logger logger = Logger.getLogger(AMQ3779Test.class);
    private static final String qName = "QNameToFind";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLogPerDest() throws Exception {
        final AtomicBoolean ok = new AtomicBoolean(false);
        DefaultTestAppender appender = new DefaultTestAppender(){

            public void doAppend(LoggingEvent event) {
                if (event.getLoggerName().toString().contains(AMQ3779Test.qName)) {
                    ok.set(true);
                }
            }
        };
        logger.getRootLogger().addAppender((Appender)appender);
        try {
            BrokerService broker = new BrokerService();
            LoggingBrokerPlugin loggingBrokerPlugin = new LoggingBrokerPlugin();
            loggingBrokerPlugin.setPerDestinationLogger(true);
            loggingBrokerPlugin.setLogAll(true);
            broker.setPlugins((BrokerPlugin[])new LoggingBrokerPlugin[]{loggingBrokerPlugin});
            broker.start();
            Connection connection = new ActiveMQConnectionFactory(broker.getVmConnectorURI()).createConnection();
            Session session = connection.createSession(false, 1);
            MessageProducer messageProducer = session.createProducer((Destination)session.createQueue(qName));
            messageProducer.setDeliveryMode(2);
            connection.start();
            messageProducer.send((Message)session.createTextMessage("Hi"));
            connection.close();
            AMQ3779Test.assertTrue((String)"got expected log message", (boolean)ok.get());
        }
        finally {
            logger.removeAppender((Appender)appender);
        }
    }
}

