/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.util.Arrays;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import javax.management.ObjectName;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.BrokerView;
import org.apache.activemq.broker.jmx.DurableSubscriptionViewMBean;
import org.apache.activemq.broker.region.policy.FilePendingDurableSubscriberMessageStoragePolicy;
import org.apache.activemq.broker.region.policy.PendingDurableSubscriberMessageStoragePolicy;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.broker.region.policy.StorePendingDurableSubscriberMessageStoragePolicy;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class AMQ4656Test {
    private static final transient Logger LOG = LoggerFactory.getLogger(AMQ4656Test.class);
    private static BrokerService brokerService;
    private static String BROKER_ADDRESS;
    private String connectionUri;
    @Parameterized.Parameter
    public PendingDurableSubscriberMessageStoragePolicy pendingDurableSubPolicy;

    @Parameterized.Parameters(name="{0}")
    public static Iterable<Object[]> getTestParameters() {
        return Arrays.asList({new FilePendingDurableSubscriberMessageStoragePolicy()}, {new StorePendingDurableSubscriberMessageStoragePolicy()});
    }

    @Before
    public void setUp() throws Exception {
        brokerService = new BrokerService();
        PolicyMap policyMap = new PolicyMap();
        PolicyEntry defaultEntry = new PolicyEntry();
        defaultEntry.setPendingDurableSubscriberPolicy(this.pendingDurableSubPolicy);
        policyMap.setDefaultEntry(defaultEntry);
        brokerService.setDestinationPolicy(policyMap);
        brokerService.setPersistent(false);
        brokerService.setUseJmx(true);
        brokerService.setDeleteAllMessagesOnStartup(true);
        this.connectionUri = brokerService.addConnector(BROKER_ADDRESS).getPublishableConnectString();
        brokerService.start();
        brokerService.waitUntilStarted();
    }

    @After
    public void tearDown() throws Exception {
        brokerService.stop();
        brokerService.waitUntilStopped();
    }

    @Test
    public void testDurableConsumerEnqueueCountWithZeroPrefetch() throws Exception {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(this.connectionUri);
        Connection connection = connectionFactory.createConnection();
        connection.setClientID(this.getClass().getName());
        connection.start();
        Session session = connection.createSession(false, 1);
        Topic destination = session.createTopic("DurableTopic");
        TopicSubscriber consumer = session.createDurableSubscriber(destination, "EnqueueSub");
        BrokerView view = brokerService.getAdminView();
        view.getDurableTopicSubscribers();
        ObjectName subName = view.getDurableTopicSubscribers()[0];
        DurableSubscriptionViewMBean sub = (DurableSubscriptionViewMBean)brokerService.getManagementContext().newProxyInstance(subName, DurableSubscriptionViewMBean.class, true);
        Assert.assertEquals((long)0L, (long)sub.getEnqueueCounter());
        Assert.assertEquals((long)0L, (long)sub.getDequeueCounter());
        Assert.assertEquals((long)0L, (long)sub.getPendingQueueSize());
        Assert.assertEquals((long)0L, (long)sub.getDispatchedCounter());
        Assert.assertEquals((long)0L, (long)sub.getDispatchedQueueSize());
        consumer.close();
        MessageProducer producer = session.createProducer((Destination)destination);
        for (int i = 0; i < 20; ++i) {
            producer.send(session.createMessage());
        }
        producer.close();
        consumer = session.createDurableSubscriber(destination, "EnqueueSub");
        Thread.sleep(1000L);
        Assert.assertEquals((long)20L, (long)sub.getEnqueueCounter());
        Assert.assertEquals((long)0L, (long)sub.getDequeueCounter());
        Assert.assertEquals((long)0L, (long)sub.getPendingQueueSize());
        Assert.assertEquals((long)20L, (long)sub.getDispatchedCounter());
        Assert.assertEquals((long)20L, (long)sub.getDispatchedQueueSize());
        LOG.info("Pending Queue Size with no receives: {}", (Object)sub.getPendingQueueSize());
        Assert.assertNotNull((Object)consumer.receive(1000L));
        Assert.assertNotNull((Object)consumer.receive(1000L));
        consumer.close();
        Thread.sleep(2000L);
        LOG.info("Pending Queue Size with two receives: {}", (Object)sub.getPendingQueueSize());
        Assert.assertEquals((long)20L, (long)sub.getEnqueueCounter());
        Assert.assertEquals((long)2L, (long)sub.getDequeueCounter());
        Assert.assertEquals((long)18L, (long)sub.getPendingQueueSize());
        Assert.assertEquals((long)20L, (long)sub.getDispatchedCounter());
        Assert.assertEquals((long)0L, (long)sub.getDispatchedQueueSize());
        session.close();
        connection.close();
    }

    static {
        BROKER_ADDRESS = "tcp://localhost:0";
    }
}

