/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import javax.jms.Connection;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.BrokerViewMBean;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AMQ5035Test {
    private static final String CLIENT_ID = "amq-test-client-id";
    private static final String DURABLE_SUB_NAME = "testDurable";
    private final String xbean = "xbean:";
    private final String confBase = "src/test/resources/org/apache/activemq/bugs/amq5035";
    private static BrokerService brokerService;
    private String connectionUri;

    @Before
    public void setUp() throws Exception {
        brokerService = BrokerFactory.createBroker((String)"xbean:src/test/resources/org/apache/activemq/bugs/amq5035/activemq.xml");
        this.connectionUri = brokerService.getTransportConnectorByScheme("tcp").getPublishableConnectString();
        brokerService.setDeleteAllMessagesOnStartup(true);
        brokerService.start();
        brokerService.waitUntilStarted();
    }

    @After
    public void tearDown() throws Exception {
        brokerService.stop();
        brokerService.waitUntilStopped();
    }

    @Test
    public void testFoo() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.connectionUri);
        Connection connection = factory.createConnection();
        connection.setClientID(CLIENT_ID);
        connection.start();
        Session session = connection.createSession(false, 1);
        Topic topic = session.createTopic("Test.Topic");
        TopicSubscriber consumer = session.createDurableSubscriber(topic, DURABLE_SUB_NAME);
        consumer.close();
        BrokerViewMBean brokerView = this.getBrokerView(DURABLE_SUB_NAME);
        brokerView.destroyDurableSubscriber(CLIENT_ID, DURABLE_SUB_NAME);
    }

    private BrokerViewMBean getBrokerView(String testDurable) throws MalformedObjectNameException {
        ObjectName brokerName = new ObjectName("org.apache.activemq:type=Broker,brokerName=localhost");
        BrokerViewMBean view = (BrokerViewMBean)brokerService.getManagementContext().newProxyInstance(brokerName, BrokerViewMBean.class, true);
        Assert.assertNotNull((Object)view);
        return view;
    }
}

