/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.load;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import org.apache.activemq.load.LoadClient;

public class LoadController
extends LoadClient {
    private int numberOfBatches = 1;
    private int batchSize = 1000;
    private int count;
    private final CountDownLatch stopped = new CountDownLatch(1);

    public LoadController(String name, ConnectionFactory factory) {
        super(name, factory);
    }

    public int awaitTestComplete() throws InterruptedException {
        this.stopped.await(300L, TimeUnit.SECONDS);
        return this.count;
    }

    @Override
    public void stop() throws JMSException, InterruptedException {
        this.running = false;
        this.stopped.countDown();
        if (this.connection != null) {
            this.connection.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            for (int i = 0; i < this.numberOfBatches; ++i) {
                int j;
                for (j = 0; j < this.batchSize; ++j) {
                    String payLoad = "batch[" + i + "]no:" + j;
                    this.send(payLoad);
                }
                for (j = 0; j < this.batchSize; ++j) {
                    String result = this.consume();
                    if (result == null) continue;
                    ++this.count;
                    this.rate.increment();
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            this.stopped.countDown();
        }
    }

    public int getNumberOfBatches() {
        return this.numberOfBatches;
    }

    public void setNumberOfBatches(int numberOfBatches) {
        this.numberOfBatches = numberOfBatches;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    @Override
    protected Destination getSendDestination() {
        return this.startDestination;
    }

    @Override
    protected Destination getConsumeDestination() {
        return this.nextDestination;
    }
}

