/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.TemporaryQueue;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.network.SimpleNetworkTest;
import org.apache.activemq.util.Wait;
import org.junit.Assert;
import org.junit.Test;

public class DuplexNetworkTest
extends SimpleNetworkTest {
    @Override
    protected String getLocalBrokerURI() {
        return "org/apache/activemq/network/duplexLocalBroker.xml";
    }

    @Override
    protected BrokerService createRemoteBroker() throws Exception {
        BrokerService broker = new BrokerService();
        broker.setBrokerName("remoteBroker");
        broker.addConnector("tcp://localhost:61617");
        return broker;
    }

    @Test
    public void testTempQueues() throws Exception {
        TemporaryQueue temp = this.localSession.createTemporaryQueue();
        MessageProducer producer = this.localSession.createProducer((Destination)temp);
        producer.send((Message)this.localSession.createTextMessage("test"));
        Thread.sleep(100L);
        Assert.assertEquals((String)"Destination not created", (long)1L, (long)this.remoteBroker.getAdminView().getTemporaryQueues().length);
        temp.delete();
        Assert.assertTrue((String)"Destination not deleted", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return 0 == DuplexNetworkTest.this.remoteBroker.getAdminView().getTemporaryQueues().length;
            }
        }));
    }
}

