/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.command.ActiveMQQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TransactionRollbackOrderTest
extends TestCase {
    private static final Logger LOG = LoggerFactory.getLogger(TransactionRollbackOrderTest.class);
    private volatile String receivedText;
    private Session producerSession;
    private Session consumerSession;
    private Destination queue;
    private MessageProducer producer;
    private MessageConsumer consumer;
    private Connection connection;
    private CountDownLatch latch = new CountDownLatch(1);
    private int numMessages = 5;
    private List<String> msgSent = new ArrayList<String>();
    private List<String> msgCommitted = new ArrayList<String>();
    private List<String> msgRolledBack = new ArrayList<String>();
    private List<String> msgRedelivered = new ArrayList<String>();

    public void testTransaction() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://localhost?broker.persistent=false");
        this.connection = factory.createConnection();
        this.queue = new ActiveMQQueue(((Object)((Object)this)).getClass().getName() + "." + this.getName());
        this.producerSession = this.connection.createSession(false, 1);
        this.consumerSession = this.connection.createSession(true, 0);
        this.producer = this.producerSession.createProducer(this.queue);
        this.consumer = this.consumerSession.createConsumer(this.queue);
        this.consumer.setMessageListener(new MessageListener(){
            int msgCount;
            int msgCommittedCount;

            public void onMessage(Message m) {
                try {
                    ++this.msgCount;
                    TextMessage tm = (TextMessage)m;
                    TransactionRollbackOrderTest.this.receivedText = tm.getText();
                    if (tm.getJMSRedelivered()) {
                        TransactionRollbackOrderTest.this.msgRedelivered.add(TransactionRollbackOrderTest.this.receivedText);
                    }
                    LOG.info("consumer received message: " + TransactionRollbackOrderTest.this.receivedText + (tm.getJMSRedelivered() ? " ** Redelivered **" : ""));
                    if (this.msgCount == 3) {
                        TransactionRollbackOrderTest.this.msgRolledBack.add(TransactionRollbackOrderTest.this.receivedText);
                        TransactionRollbackOrderTest.this.consumerSession.rollback();
                        LOG.info("[msg: " + TransactionRollbackOrderTest.this.receivedText + "] ** rolled back **");
                    } else {
                        ++this.msgCommittedCount;
                        TransactionRollbackOrderTest.this.msgCommitted.add(TransactionRollbackOrderTest.this.receivedText);
                        TransactionRollbackOrderTest.this.consumerSession.commit();
                        LOG.info("[msg: " + TransactionRollbackOrderTest.this.receivedText + "] committed transaction ");
                    }
                    if (this.msgCommittedCount == TransactionRollbackOrderTest.this.numMessages) {
                        TransactionRollbackOrderTest.this.latch.countDown();
                    }
                }
                catch (JMSException e) {
                    try {
                        TransactionRollbackOrderTest.this.consumerSession.rollback();
                        LOG.info("rolled back transaction");
                    }
                    catch (JMSException e1) {
                        LOG.info(e1.toString());
                        e1.printStackTrace();
                    }
                    LOG.info(e.toString());
                    e.printStackTrace();
                }
            }
        });
        this.connection.start();
        TextMessage tm = null;
        try {
            for (int i = 1; i <= this.numMessages; ++i) {
                tm = this.producerSession.createTextMessage();
                tm.setText("Hello " + i);
                this.msgSent.add(tm.getText());
                this.producer.send((Message)tm);
                LOG.info("producer sent message: " + tm.getText());
            }
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
        LOG.info("Waiting for latch");
        this.latch.await();
        TransactionRollbackOrderTest.assertEquals((int)1, (int)this.msgRolledBack.size());
        TransactionRollbackOrderTest.assertEquals((int)1, (int)this.msgRedelivered.size());
        LOG.info("msg RolledBack = " + this.msgRolledBack.get(0));
        LOG.info("msg Redelivered = " + this.msgRedelivered.get(0));
        TransactionRollbackOrderTest.assertEquals((String)this.msgRolledBack.get(0), (String)this.msgRedelivered.get(0));
        TransactionRollbackOrderTest.assertEquals((int)this.numMessages, (int)this.msgSent.size());
        TransactionRollbackOrderTest.assertEquals((int)this.numMessages, (int)this.msgCommitted.size());
        TransactionRollbackOrderTest.assertEquals(this.msgSent, this.msgCommitted);
    }

    protected void tearDown() throws Exception {
        if (this.connection != null) {
            LOG.info("Closing the connection");
            this.connection.close();
        }
        super.tearDown();
    }
}

