/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker;

import java.util.ArrayList;
import java.util.Collection;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.management.ObjectName;
import org.apache.activemq.TestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.util.JMXSupport;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class QueueMbeanRestartTest
extends TestSupport {
    private static final transient Logger LOG = LoggerFactory.getLogger(QueueMbeanRestartTest.class);
    BrokerService broker;
    private final TestSupport.PersistenceAdapterChoice persistenceAdapterChoice;

    @Parameterized.Parameters
    public static Collection<TestSupport.PersistenceAdapterChoice[]> getTestParameters() {
        TestSupport.PersistenceAdapterChoice[] kahaDb = new TestSupport.PersistenceAdapterChoice[]{TestSupport.PersistenceAdapterChoice.KahaDB};
        TestSupport.PersistenceAdapterChoice[] levelDb = new TestSupport.PersistenceAdapterChoice[]{TestSupport.PersistenceAdapterChoice.LevelDB};
        TestSupport.PersistenceAdapterChoice[] jdbc = new TestSupport.PersistenceAdapterChoice[]{TestSupport.PersistenceAdapterChoice.JDBC};
        ArrayList<TestSupport.PersistenceAdapterChoice[]> choices = new ArrayList<TestSupport.PersistenceAdapterChoice[]>();
        choices.add(kahaDb);
        choices.add(levelDb);
        choices.add(jdbc);
        return choices;
    }

    public QueueMbeanRestartTest(TestSupport.PersistenceAdapterChoice choice) {
        this.persistenceAdapterChoice = choice;
    }

    @Before
    public void setUp() throws Exception {
        this.topic = false;
        super.setUp();
    }

    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.broker.stop();
    }

    @Test(timeout=60000L)
    public void testMBeanPresenceOnRestart() throws Exception {
        this.createBroker(true);
        this.sendMessages();
        this.verifyPresenceOfQueueMbean();
        LOG.info("restart....");
        this.restartBroker();
        this.verifyPresenceOfQueueMbean();
    }

    private void restartBroker() throws Exception {
        this.broker.stop();
        this.broker.waitUntilStopped();
        Thread.sleep(5000L);
        this.createBroker(false);
        this.broker.waitUntilStarted();
    }

    private void verifyPresenceOfQueueMbean() throws Exception {
        for (ObjectName name : this.broker.getManagementContext().queryNames(null, null)) {
            LOG.info("candidate :" + name);
            String type = name.getKeyProperty("destinationType");
            if (type == null || !type.equals("Queue")) continue;
            QueueMbeanRestartTest.assertEquals((String)JMXSupport.encodeObjectNamePart((String)((ActiveMQQueue)this.createDestination()).getPhysicalName()), (String)name.getKeyProperty("destinationName"));
            LOG.info("found mbbean " + name);
            return;
        }
        QueueMbeanRestartTest.fail((String)("expected to find matching queue mbean for: " + this.createDestination()));
    }

    private void sendMessages() throws Exception {
        Session session = this.createConnection().createSession(false, 1);
        MessageProducer producer = session.createProducer(this.createDestination());
        producer.send((Message)session.createTextMessage());
    }

    private void createBroker(boolean deleteAll) throws Exception {
        this.broker = new BrokerService();
        this.setPersistenceAdapter(this.broker, this.persistenceAdapterChoice);
        this.broker.setDeleteAllMessagesOnStartup(deleteAll);
        this.broker.start();
    }
}

