/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.plugin;

import java.net.URI;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerPlugin;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.plugin.StatisticsBrokerPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerStatisticsPluginTest
extends TestCase {
    private static final Logger LOG = LoggerFactory.getLogger(BrokerStatisticsPluginTest.class);
    private Connection connection;
    private BrokerService broker;

    public void testBrokerStats() throws Exception {
        Session session = this.connection.createSession(false, 1);
        TemporaryQueue replyTo = session.createTemporaryQueue();
        MessageConsumer consumer = session.createConsumer((Destination)replyTo);
        Queue query = session.createQueue("ActiveMQ.Statistics.Broker");
        MessageProducer producer = session.createProducer((Destination)query);
        Message msg = session.createMessage();
        msg.setJMSReplyTo((Destination)replyTo);
        producer.send(msg);
        MapMessage reply = (MapMessage)consumer.receive(10000L);
        BrokerStatisticsPluginTest.assertNotNull((Object)reply);
        BrokerStatisticsPluginTest.assertTrue((boolean)reply.getMapNames().hasMoreElements());
        BrokerStatisticsPluginTest.assertTrue((reply.getJMSTimestamp() > 0L ? 1 : 0) != 0);
        BrokerStatisticsPluginTest.assertEquals((int)4, (int)reply.getJMSPriority());
    }

    public void testBrokerStatsReset() throws Exception {
        Session session = this.connection.createSession(false, 1);
        TemporaryQueue replyTo = session.createTemporaryQueue();
        MessageConsumer consumer = session.createConsumer((Destination)replyTo);
        Queue testQueue = session.createQueue("Test.Queue");
        Queue query = session.createQueue("ActiveMQ.Statistics.Broker");
        MessageProducer producer = session.createProducer(null);
        producer.send((Destination)testQueue, session.createMessage());
        Message msg = session.createMessage();
        msg.setJMSReplyTo((Destination)replyTo);
        producer.send((Destination)query, msg);
        MapMessage reply = (MapMessage)consumer.receive(10000L);
        BrokerStatisticsPluginTest.assertNotNull((Object)reply);
        BrokerStatisticsPluginTest.assertTrue((boolean)reply.getMapNames().hasMoreElements());
        BrokerStatisticsPluginTest.assertTrue((reply.getLong("enqueueCount") >= 1L ? 1 : 0) != 0);
        msg = session.createMessage();
        msg.setBooleanProperty("ActiveMQ.Statistics.Broker.Reset", true);
        msg.setJMSReplyTo((Destination)replyTo);
        producer.send((Destination)query, msg);
        reply = (MapMessage)consumer.receive(10000L);
        BrokerStatisticsPluginTest.assertNotNull((Object)reply);
        BrokerStatisticsPluginTest.assertTrue((boolean)reply.getMapNames().hasMoreElements());
        BrokerStatisticsPluginTest.assertEquals((long)0L, (long)reply.getLong("enqueueCount"));
        BrokerStatisticsPluginTest.assertTrue((reply.getJMSTimestamp() > 0L ? 1 : 0) != 0);
        BrokerStatisticsPluginTest.assertEquals((int)4, (int)reply.getJMSPriority());
    }

    public void testDestinationStats() throws Exception {
        Session session = this.connection.createSession(false, 1);
        TemporaryQueue replyTo = session.createTemporaryQueue();
        MessageConsumer consumer = session.createConsumer((Destination)replyTo);
        Queue testQueue = session.createQueue("Test.Queue");
        MessageProducer producer = session.createProducer(null);
        Queue query = session.createQueue("ActiveMQ.Statistics.Destination" + testQueue.getQueueName());
        Message msg = session.createMessage();
        producer.send((Destination)testQueue, msg);
        msg.setJMSReplyTo((Destination)replyTo);
        producer.send((Destination)query, msg);
        MapMessage reply = (MapMessage)consumer.receive();
        BrokerStatisticsPluginTest.assertNotNull((Object)reply);
        BrokerStatisticsPluginTest.assertTrue((boolean)reply.getMapNames().hasMoreElements());
        BrokerStatisticsPluginTest.assertTrue((reply.getJMSTimestamp() > 0L ? 1 : 0) != 0);
        BrokerStatisticsPluginTest.assertEquals((int)4, (int)reply.getJMSPriority());
    }

    public void testSubscriptionStats() throws Exception {
        Session session = this.connection.createSession(false, 1);
        TemporaryQueue replyTo = session.createTemporaryQueue();
        MessageConsumer consumer = session.createConsumer((Destination)replyTo);
        Queue testQueue = session.createQueue("Test.Queue");
        MessageConsumer testConsumer = session.createConsumer((Destination)testQueue);
        MessageProducer producer = session.createProducer(null);
        Queue query = session.createQueue("ActiveMQ.Statistics.Subscription");
        Message msg = session.createMessage();
        producer.send((Destination)testQueue, msg);
        msg.setJMSReplyTo((Destination)replyTo);
        producer.send((Destination)query, msg);
        MapMessage reply = (MapMessage)consumer.receive();
        BrokerStatisticsPluginTest.assertNotNull((Object)reply);
        BrokerStatisticsPluginTest.assertTrue((boolean)reply.getMapNames().hasMoreElements());
        BrokerStatisticsPluginTest.assertTrue((reply.getJMSTimestamp() > 0L ? 1 : 0) != 0);
        BrokerStatisticsPluginTest.assertEquals((int)4, (int)reply.getJMSPriority());
    }

    protected void setUp() throws Exception {
        this.broker = this.createBroker();
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory((String)this.broker.getTransportConnectorURIsAsMap().get("tcp"));
        this.connection = factory.createConnection();
        this.connection.start();
    }

    protected void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
        if (this.broker != null) {
            this.broker.stop();
        }
    }

    protected BrokerService createBroker() throws Exception {
        BrokerService answer = new BrokerService();
        BrokerPlugin[] plugins = new BrokerPlugin[]{new StatisticsBrokerPlugin()};
        answer.setPlugins(plugins);
        answer.setDeleteAllMessagesOnStartup(true);
        answer.addConnector("tcp://localhost:0");
        answer.start();
        return answer;
    }

    protected BrokerService createBroker(String uri) throws Exception {
        LOG.info("Loading broker configuration from the classpath with URI: " + uri);
        return BrokerFactory.createBroker((URI)new URI("xbean:" + uri));
    }
}

