/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.vm;

import java.net.URI;
import javax.jms.Connection;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerRegistry;

public class VMTransportBrokerNameTest
extends TestCase {
    private static final String MY_BROKER = "myBroker";
    final String vmUrl = "vm:(broker:(tcp://localhost:61616)/myBroker?persistent=false)";

    public void testBrokerName() throws Exception {
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory(new URI("vm:(broker:(tcp://localhost:61616)/myBroker?persistent=false)"));
        ActiveMQConnection c1 = (ActiveMQConnection)cf.createConnection();
        VMTransportBrokerNameTest.assertTrue((String)("Transport has name in it: " + c1.getTransport()), (boolean)c1.getTransport().toString().contains(MY_BROKER));
        ActiveMQConnectionFactory cfbyName = new ActiveMQConnectionFactory(new URI("vm://myBroker?create=false"));
        Connection c2 = cfbyName.createConnection();
        VMTransportBrokerNameTest.assertNotNull((Object)BrokerRegistry.getInstance().lookup(MY_BROKER));
        VMTransportBrokerNameTest.assertEquals((String)BrokerRegistry.getInstance().findFirst().getBrokerName(), (String)MY_BROKER);
        VMTransportBrokerNameTest.assertEquals((int)BrokerRegistry.getInstance().getBrokers().size(), (int)1);
        c1.close();
        c2.close();
    }
}

