/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQMessageConsumer;
import org.apache.activemq.JmsMultipleBrokersTestSupport;
import org.apache.activemq.command.ActiveMQQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class TwoSecureBrokerRequestReplyTest
extends JmsMultipleBrokersTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(TwoSecureBrokerRequestReplyTest.class);

    @Override
    public void setUp() throws Exception {
        super.setAutoFail(true);
        super.setUp();
        this.createBroker((Resource)new ClassPathResource("org/apache/activemq/usecases/sender-secured.xml"));
        this.createBroker((Resource)new ClassPathResource("org/apache/activemq/usecases/receiver-secured.xml"));
    }

    public void testRequestReply() throws Exception {
        ActiveMQQueue requestReplyDest = new ActiveMQQueue("RequestReply");
        this.startAllBrokers();
        this.waitForBridgeFormation();
        this.waitForMinTopicRegionConsumerCount("sender", 1);
        this.waitForMinTopicRegionConsumerCount("receiver", 1);
        ConnectionFactory factory = this.getConnectionFactory("sender");
        ActiveMQConnection conn = (ActiveMQConnection)factory.createConnection("system", "manager");
        conn.setWatchTopicAdvisories(false);
        conn.start();
        Session session = conn.createSession(false, 1);
        ConnectionFactory replyFactory = this.getConnectionFactory("receiver");
        for (int i = 0; i < 2000; ++i) {
            TemporaryQueue tempDest = session.createTemporaryQueue();
            MessageProducer producer = session.createProducer((Destination)requestReplyDest);
            TextMessage message = session.createTextMessage("req-" + i);
            message.setJMSReplyTo((Destination)tempDest);
            ActiveMQMessageConsumer consumer = (ActiveMQMessageConsumer)session.createConsumer((Destination)tempDest);
            producer.send((Message)message);
            ActiveMQConnection replyConnection = (ActiveMQConnection)replyFactory.createConnection("system", "manager");
            replyConnection.setWatchTopicAdvisories(false);
            replyConnection.start();
            Session replySession = replyConnection.createSession(false, 1);
            ActiveMQMessageConsumer replyConsumer = (ActiveMQMessageConsumer)replySession.createConsumer((Destination)requestReplyDest);
            Message msg = replyConsumer.receive(10000L);
            TwoSecureBrokerRequestReplyTest.assertNotNull((String)("request message not null: " + i), (Object)msg);
            MessageProducer replyProducer = replySession.createProducer(msg.getJMSReplyTo());
            replyProducer.send((Message)session.createTextMessage("reply-" + i));
            replyConnection.close();
            Message reply = consumer.receive(10000L);
            TwoSecureBrokerRequestReplyTest.assertNotNull((String)("reply message : " + i + ", to: " + tempDest + ", by consumer:" + consumer.getConsumerId()), (Object)reply);
            consumer.close();
            tempDest.delete();
            LOG.info("message #" + i + " processed");
        }
    }
}

