/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.advisory;

import java.net.URI;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.advisory.AdvisorySupport;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.BrokerInfo;

public class AdvisoryNetworkBridgeTest
extends TestCase {
    BrokerService broker1;
    BrokerService broker2;

    public void testAdvisory() throws Exception {
        this.createBroker1();
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://broker1");
        Connection conn = factory.createConnection();
        Session sess = conn.createSession(false, 1);
        conn.start();
        MessageConsumer consumer = sess.createConsumer((Destination)AdvisorySupport.getNetworkBridgeAdvisoryTopic());
        Thread.sleep(1000L);
        this.createBroker2();
        ActiveMQMessage advisory = (ActiveMQMessage)consumer.receive(2000L);
        AdvisoryNetworkBridgeTest.assertNotNull((Object)advisory);
        AdvisoryNetworkBridgeTest.assertTrue((boolean)(advisory.getDataStructure() instanceof BrokerInfo));
        AdvisoryNetworkBridgeTest.assertTrue((boolean)advisory.getBooleanProperty("started"));
        this.assertCreatedByDuplex(advisory.getBooleanProperty("createdByDuplex"));
        this.broker2.stop();
        this.broker2.waitUntilStopped();
        advisory = (ActiveMQMessage)consumer.receive(2000L);
        AdvisoryNetworkBridgeTest.assertNotNull((Object)advisory);
        AdvisoryNetworkBridgeTest.assertTrue((boolean)(advisory.getDataStructure() instanceof BrokerInfo));
        AdvisoryNetworkBridgeTest.assertFalse((boolean)advisory.getBooleanProperty("started"));
        conn.close();
    }

    public void testAddConsumerLater() throws Exception {
        this.createBroker1();
        this.createBroker2();
        Thread.sleep(1000L);
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://broker1");
        Connection conn = factory.createConnection();
        Session sess = conn.createSession(false, 1);
        conn.start();
        MessageConsumer consumer = sess.createConsumer((Destination)AdvisorySupport.getNetworkBridgeAdvisoryTopic());
        ActiveMQMessage advisory = (ActiveMQMessage)consumer.receive(2000L);
        AdvisoryNetworkBridgeTest.assertNotNull((Object)advisory);
        AdvisoryNetworkBridgeTest.assertTrue((boolean)(advisory.getDataStructure() instanceof BrokerInfo));
        AdvisoryNetworkBridgeTest.assertTrue((boolean)advisory.getBooleanProperty("started"));
        this.assertCreatedByDuplex(advisory.getBooleanProperty("createdByDuplex"));
        this.broker2.stop();
        this.broker2.waitUntilStopped();
        advisory = (ActiveMQMessage)consumer.receive(2000L);
        AdvisoryNetworkBridgeTest.assertNotNull((Object)advisory);
        AdvisoryNetworkBridgeTest.assertTrue((boolean)(advisory.getDataStructure() instanceof BrokerInfo));
        AdvisoryNetworkBridgeTest.assertFalse((boolean)advisory.getBooleanProperty("started"));
        consumer = sess.createConsumer((Destination)AdvisorySupport.getNetworkBridgeAdvisoryTopic());
        advisory = (ActiveMQMessage)consumer.receive(1000L);
        AdvisoryNetworkBridgeTest.assertNull((Object)advisory);
        conn.close();
    }

    public void assertCreatedByDuplex(boolean createdByDuplex) {
        AdvisoryNetworkBridgeTest.assertFalse((boolean)createdByDuplex);
    }

    public void createBroker1() throws Exception {
        this.broker1 = BrokerFactory.createBroker((URI)new URI("xbean:org/apache/activemq/network/reconnect-broker1.xml"));
        this.broker1.start();
        this.broker1.waitUntilStarted();
    }

    public void createBroker2() throws Exception {
        this.broker2 = BrokerFactory.createBroker((URI)new URI("xbean:org/apache/activemq/network/reconnect-broker2.xml"));
        this.broker2.start();
        this.broker2.waitUntilStarted();
    }

    protected void tearDown() throws Exception {
        this.broker1.stop();
        this.broker1.waitUntilStopped();
        this.broker2.stop();
        this.broker2.waitUntilStopped();
    }
}

