/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.util.Date;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerPlugin;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.DestinationInterceptor;
import org.apache.activemq.broker.region.virtual.VirtualDestination;
import org.apache.activemq.broker.region.virtual.VirtualDestinationInterceptor;
import org.apache.activemq.broker.region.virtual.VirtualTopic;
import org.apache.activemq.bugs.AMQ4899Listener;
import org.apache.activemq.plugin.SubQueueSelectorCacheBrokerPlugin;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ4899Test {
    protected static final Logger LOG = LoggerFactory.getLogger(AMQ4899Test.class);
    private static final String QUEUE_NAME = "AMQ4899TestQueue";
    private static final String CONSUMER_QUEUE = "Consumer.Orders.VirtualOrders.AMQ4899TestQueue";
    private static final String PRODUCER_DESTINATION_NAME = "VirtualOrders.AMQ4899TestQueue";
    private static final Integer MESSAGE_LIMIT = 20;
    public static final String CONSUMER_A_SELECTOR = "Order < 10";
    public static String CONSUMER_B_SELECTOR = "Order >= 10";
    private CountDownLatch consumersStarted = new CountDownLatch(2);
    private CountDownLatch consumerAtoConsumeCount = new CountDownLatch(10);
    private CountDownLatch consumerBtoConsumeCount = new CountDownLatch(10);
    private BrokerService broker;

    @Before
    public void setUp() {
        this.setupBroker("broker://()/localhost?");
    }

    @After
    public void tearDown() throws Exception {
        if (this.broker != null) {
            this.broker.stop();
            this.broker.waitUntilStopped();
        }
    }

    @Test(timeout=60000L)
    public void testVirtualTopicMultipleSelectors() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://localhost");
        Connection connection = factory.createConnection();
        connection.start();
        Session session = connection.createSession(false, 1);
        Queue consumerQueue = session.createQueue(CONSUMER_QUEUE);
        AMQ4899Listener listenerA = new AMQ4899Listener("A", this.consumersStarted, this.consumerAtoConsumeCount);
        MessageConsumer consumerA = session.createConsumer((Destination)consumerQueue, CONSUMER_A_SELECTOR);
        consumerA.setMessageListener((MessageListener)listenerA);
        AMQ4899Listener listenerB = new AMQ4899Listener("B", this.consumersStarted, this.consumerBtoConsumeCount);
        MessageConsumer consumerB = session.createConsumer((Destination)consumerQueue, CONSUMER_B_SELECTOR);
        consumerB.setMessageListener((MessageListener)listenerB);
        this.consumersStarted.await(10L, TimeUnit.SECONDS);
        Assert.assertEquals((String)"Not all consumers started in time", (long)0L, (long)this.consumersStarted.getCount());
        Topic producerDestination = session.createTopic(PRODUCER_DESTINATION_NAME);
        MessageProducer producer = session.createProducer((Destination)producerDestination);
        int messageIndex = 0;
        for (int i = 0; i < MESSAGE_LIMIT; ++i) {
            if (i == 3) {
                LOG.debug("Stopping consumerA");
                consumerA.close();
            }
            if (i == 14) {
                LOG.debug("Stopping consumer B");
                consumerB.close();
            }
            String messageText = "hello " + messageIndex++ + " sent at " + new Date().toString();
            TextMessage message = session.createTextMessage(messageText);
            message.setIntProperty("Order", i);
            LOG.debug("Sending message [{}]", (Object)messageText);
            producer.send((Message)message);
            Thread.sleep(100L);
        }
        Thread.sleep(1000L);
        LOG.debug("Restarting consumerA");
        consumerA = session.createConsumer((Destination)consumerQueue, CONSUMER_A_SELECTOR);
        consumerA.setMessageListener((MessageListener)listenerA);
        LOG.debug("restarting consumerB");
        consumerB = session.createConsumer((Destination)consumerQueue, CONSUMER_B_SELECTOR);
        consumerB.setMessageListener((MessageListener)listenerB);
        this.consumerAtoConsumeCount.await(5L, TimeUnit.SECONDS);
        this.consumerBtoConsumeCount.await(5L, TimeUnit.SECONDS);
        LOG.debug("Unconsumed messages for consumerA {} consumerB {}", (Object)this.consumerAtoConsumeCount.getCount(), (Object)this.consumerBtoConsumeCount.getCount());
        Assert.assertEquals((String)"Consumer A did not consume all messages", (long)0L, (long)this.consumerAtoConsumeCount.getCount());
        Assert.assertEquals((String)"Consumer B did not consume all messages", (long)0L, (long)this.consumerBtoConsumeCount.getCount());
        connection.close();
    }

    private void setupBroker(String uri) {
        try {
            this.broker = BrokerFactory.createBroker((String)uri);
            VirtualDestinationInterceptor interceptor = new VirtualDestinationInterceptor();
            VirtualTopic virtualTopic = new VirtualTopic();
            virtualTopic.setName("VirtualOrders.>");
            virtualTopic.setSelectorAware(true);
            VirtualDestination[] virtualDestinations = new VirtualDestination[]{virtualTopic};
            interceptor.setVirtualDestinations(virtualDestinations);
            this.broker.setDestinationInterceptors(new DestinationInterceptor[]{interceptor});
            SubQueueSelectorCacheBrokerPlugin subQueueSelectorCacheBrokerPlugin = new SubQueueSelectorCacheBrokerPlugin();
            BrokerPlugin[] updatedPlugins = new BrokerPlugin[]{subQueueSelectorCacheBrokerPlugin};
            this.broker.setPlugins(updatedPlugins);
            this.broker.start();
            this.broker.waitUntilStarted();
        }
        catch (Exception e) {
            LOG.error("Failed creating broker", (Throwable)e);
        }
    }
}

