/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.nio;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Queue;
import javax.jms.Session;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.util.ConsumerThread;
import org.apache.activemq.util.ProducerThread;
import org.apache.activemq.util.Wait;

public class NIOSSLLoadTest
extends TestCase {
    BrokerService broker;
    Connection connection;
    Session session;
    public static final String KEYSTORE_TYPE = "jks";
    public static final String PASSWORD = "password";
    public static final String SERVER_KEYSTORE = "src/test/resources/server.keystore";
    public static final String TRUST_KEYSTORE = "src/test/resources/client.keystore";
    public static final int PRODUCER_COUNT = 10;
    public static final int CONSUMER_COUNT = 10;
    public static final int MESSAGE_COUNT = 1000;
    final ConsumerThread[] consumers = new ConsumerThread[10];

    protected void setUp() throws Exception {
        System.setProperty("javax.net.ssl.trustStore", TRUST_KEYSTORE);
        System.setProperty("javax.net.ssl.trustStorePassword", PASSWORD);
        System.setProperty("javax.net.ssl.trustStoreType", KEYSTORE_TYPE);
        System.setProperty("javax.net.ssl.keyStore", SERVER_KEYSTORE);
        System.setProperty("javax.net.ssl.keyStoreType", KEYSTORE_TYPE);
        System.setProperty("javax.net.ssl.keyStorePassword", PASSWORD);
        this.broker = new BrokerService();
        this.broker.setPersistent(false);
        this.broker.setUseJmx(false);
        TransportConnector connector = this.broker.addConnector("nio+ssl://localhost:0?transport.needClientAuth=true&transport.enabledCipherSuites=SSL_RSA_WITH_RC4_128_SHA,SSL_DH_anon_WITH_3DES_EDE_CBC_SHA");
        this.broker.start();
        this.broker.waitUntilStarted();
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("nio+ssl://localhost:" + connector.getConnectUri().getPort());
        this.connection = factory.createConnection();
        this.session = this.connection.createSession(false, 1);
        this.connection.start();
    }

    protected void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
        if (this.broker != null) {
            this.broker.stop();
            this.broker.waitUntilStopped();
        }
    }

    public void testLoad() throws Exception {
        int i;
        Queue dest = this.session.createQueue("TEST");
        for (i = 0; i < 10; ++i) {
            ProducerThread producer = new ProducerThread(this.session, (Destination)dest);
            producer.setMessageCount(1000);
            producer.start();
        }
        for (i = 0; i < 10; ++i) {
            ConsumerThread consumer = new ConsumerThread(this.session, (Destination)dest);
            consumer.setMessageCount(1000);
            consumer.start();
            this.consumers[i] = consumer;
        }
        Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return NIOSSLLoadTest.this.getReceived() == 10000;
            }
        }, (long)60000L);
        NIOSSLLoadTest.assertEquals((int)10000, (int)this.getReceived());
    }

    protected int getReceived() {
        int received = 0;
        for (ConsumerThread consumer : this.consumers) {
            received += consumer.getReceived();
        }
        return received;
    }
}

