/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usage;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.BrokerService;

public class StoreUsageLimitsTest
extends EmbeddedBrokerTestSupport {
    final int WAIT_TIME_MILLS = 20000;
    private static final String limitsLogLevel = "error";

    @Override
    protected BrokerService createBroker() throws Exception {
        BrokerService broker = super.createBroker();
        broker.getSystemUsage().getMemoryUsage().setLimit(Long.MAX_VALUE);
        broker.getSystemUsage().setCheckLimitsLogLevel(limitsLogLevel);
        broker.deleteAllMessages();
        return broker;
    }

    @Override
    protected boolean isPersistent() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCheckLimitsLogLevel() throws Exception {
        File file = new File("target/activemq-test.log");
        if (!file.exists()) {
            StoreUsageLimitsTest.fail((String)"target/activemq-test.log was not created.");
        }
        BufferedReader br = null;
        boolean foundUsage = false;
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Charset.forName("UTF-8")));
            String line = null;
            while ((line = br.readLine()) != null) {
                if (!line.contains(new String(Long.toString(0x7FFFFFFFFFFL))) || !line.contains(limitsLogLevel.toUpperCase())) continue;
                foundUsage = true;
            }
        }
        catch (Exception e) {
            StoreUsageLimitsTest.fail((String)e.getMessage());
        }
        finally {
            br.close();
        }
        if (!foundUsage) {
            StoreUsageLimitsTest.fail((String)"checkLimitsLogLevel message did not write to log target/activemq-test.log");
        }
    }
}

