/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Vector;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQMessageConsumer;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.leveldb.LevelDBStore;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;
import org.apache.activemq.util.ThreadTracker;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DurableSubProcessConcurrentCommitActivateNoDuplicateTest {
    private static final Logger LOG = LoggerFactory.getLogger(DurableSubProcessConcurrentCommitActivateNoDuplicateTest.class);
    public static final long RUNTIME = 300000L;
    public static final int SERVER_SLEEP = 500;
    public static final int CARGO_SIZE = 600;
    public static final int MAX_CLIENTS = 2;
    public static final Random CLIENT_LIFETIME = new Random(30000, 120000);
    public static final Random CLIENT_ONLINE = new Random(30000, 40000);
    public static final Random CLIENT_OFFLINE = new Random(1000, 10000);
    public static final int CLIENT_OFFLINE_DURING_COMMIT = 2;
    public static final Persistence PERSISTENT_ADAPTER = Persistence.KAHADB;
    public static final long BROKER_RESTART = -120000L;
    public static final boolean ALLOW_SUBSCRIPTION_ABANDONMENT = true;
    public static final boolean CHECK_REDELIVERY = true;
    private BrokerService broker;
    private ActiveMQTopic topic;
    private ClientManager clientManager;
    private Server server;
    private HouseKeeper houseKeeper;
    private final ReentrantReadWriteLock processLock = new ReentrantReadWriteLock(true);
    private int restartCount = 0;
    private final AtomicInteger onlineCount = new AtomicInteger(0);
    static final Vector<Throwable> exceptions = new Vector();

    @Ignore(value="short version in org.apache.activemq.usecases.DurableSubscriptionOfflineTest.testNoDuplicateOnConcurrentSendTranCommitAndActivate and org.apache.activemq.usecases.DurableSubscriptionOfflineTest.testOrderOnActivateDeactivate")
    @Test
    public void testProcess() {
        try {
            this.server.start();
            this.clientManager.start();
            this.houseKeeper.start();
            Thread.sleep(300000L);
        }
        catch (Throwable e) {
            DurableSubProcessConcurrentCommitActivateNoDuplicateTest.exit("ProcessTest.testProcess failed.", e);
        }
        this.clientManager.setEnd(true);
        try {
            Thread.sleep(60000L);
        }
        catch (InterruptedException e) {
            DurableSubProcessConcurrentCommitActivateNoDuplicateTest.exit("ProcessTest.testProcess failed.", e);
        }
        this.server.done = true;
        try {
            this.server.join(60000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.processLock.writeLock().lock();
        Assert.assertTrue((String)("no exceptions: " + exceptions), (boolean)exceptions.isEmpty());
        LOG.info("DONE.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restartBroker() throws Exception {
        LOG.info("Broker restart: waiting for components.");
        this.processLock.writeLock().lock();
        try {
            this.destroyBroker();
            this.startBroker(false);
            ++this.restartCount;
            LOG.info("Broker restarted. count: " + this.restartCount);
        }
        finally {
            this.processLock.writeLock().unlock();
        }
    }

    public static int random(int max) {
        return (int)(Math.random() * (double)(max + 1));
    }

    public static int random(int min, int max) {
        return DurableSubProcessConcurrentCommitActivateNoDuplicateTest.random(max - min) + min;
    }

    public static void sleepRandom(int maxMillis) throws InterruptedException {
        Thread.sleep(DurableSubProcessConcurrentCommitActivateNoDuplicateTest.random(maxMillis));
    }

    public static void sleepRandom(int minMillis, int maxMillis) throws InterruptedException {
        Thread.sleep(DurableSubProcessConcurrentCommitActivateNoDuplicateTest.random(minMillis, maxMillis));
    }

    public static void exit(String message) {
        DurableSubProcessConcurrentCommitActivateNoDuplicateTest.exit(message, null);
    }

    public static void exit(String message, Throwable e) {
        RuntimeException cause = new RuntimeException(message, e);
        LOG.error(message, (Throwable)cause);
        exceptions.add(cause);
        ThreadTracker.result();
        System.exit(-9);
    }

    @Before
    public void setUp() throws Exception {
        this.topic = new ActiveMQTopic("TopicT");
        this.startBroker();
        this.clientManager = new ClientManager();
        this.server = new Server();
        this.houseKeeper = new HouseKeeper();
    }

    @After
    public void tearDown() throws Exception {
        this.destroyBroker();
    }

    private void startBroker() throws Exception {
        this.startBroker(true);
    }

    private void startBroker(boolean deleteAllMessages) throws Exception {
        if (this.broker != null) {
            return;
        }
        this.broker = BrokerFactory.createBroker((String)("broker:(vm://" + DurableSubProcessConcurrentCommitActivateNoDuplicateTest.getName() + ")"));
        this.broker.setBrokerName(DurableSubProcessConcurrentCommitActivateNoDuplicateTest.getName());
        this.broker.setAdvisorySupport(false);
        this.broker.setDeleteAllMessagesOnStartup(deleteAllMessages);
        switch (PERSISTENT_ADAPTER) {
            case MEMORY: {
                this.broker.setPersistent(false);
                break;
            }
            case LEVELDB: {
                File amqData = new File("activemq-data/" + DurableSubProcessConcurrentCommitActivateNoDuplicateTest.getName() + "-leveldb");
                if (deleteAllMessages) {
                    DurableSubProcessConcurrentCommitActivateNoDuplicateTest.delete(amqData);
                }
                this.broker.setPersistent(true);
                LevelDBStore amq = new LevelDBStore();
                amq.setDirectory(amqData);
                this.broker.setPersistenceAdapter((PersistenceAdapter)amq);
                break;
            }
            case KAHADB: {
                File kahadbData = new File("activemq-data/" + DurableSubProcessConcurrentCommitActivateNoDuplicateTest.getName() + "-kahadb");
                if (deleteAllMessages) {
                    DurableSubProcessConcurrentCommitActivateNoDuplicateTest.delete(kahadbData);
                }
                this.broker.setPersistent(true);
                KahaDBPersistenceAdapter kahadb = new KahaDBPersistenceAdapter();
                kahadb.setDirectory(kahadbData);
                kahadb.setJournalMaxFileLength(0x500000);
                this.broker.setPersistenceAdapter((PersistenceAdapter)kahadb);
            }
        }
        this.broker.addConnector("tcp://localhost:61656");
        this.broker.getSystemUsage().getMemoryUsage().setLimit(0x10000000L);
        this.broker.getSystemUsage().getTempUsage().setLimit(0x10000000L);
        this.broker.getSystemUsage().getStoreUsage().setLimit(0x40000000L);
        PolicyMap policyMap = new PolicyMap();
        PolicyEntry defaultEntry = new PolicyEntry();
        defaultEntry.setMaxAuditDepth(20000);
        policyMap.setDefaultEntry(defaultEntry);
        this.broker.setDestinationPolicy(policyMap);
        this.broker.start();
    }

    protected static String getName() {
        return "DurableSubProcessWithRestartTest";
    }

    private static boolean delete(File path) {
        if (path == null) {
            return true;
        }
        if (path.isDirectory()) {
            for (File file : path.listFiles()) {
                DurableSubProcessConcurrentCommitActivateNoDuplicateTest.delete(file);
            }
        }
        return path.delete();
    }

    private void destroyBroker() throws Exception {
        if (this.broker == null) {
            return;
        }
        this.broker.stop();
        this.broker = null;
    }

    private static enum Persistence {
        MEMORY,
        LEVELDB,
        KAHADB;

    }

    public static final class Random {
        final int min;
        final int max;

        Random(int min, int max) {
            this.min = min;
            this.max = max;
        }

        public int next() {
            return DurableSubProcessConcurrentCommitActivateNoDuplicateTest.random(this.min, this.max);
        }

        public void sleepRandom() throws InterruptedException {
            DurableSubProcessConcurrentCommitActivateNoDuplicateTest.sleepRandom(this.min, this.max);
        }
    }

    private final class HouseKeeper
    extends Thread {
        public final CopyOnWriteArrayList<String> abandonedSubscriptions;

        private HouseKeeper() {
            super("HouseKeeper");
            this.abandonedSubscriptions = new CopyOnWriteArrayList();
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) lbl-1000:
                    // 3 sources

                    {
                        Thread.sleep(180000L);
                        DurableSubProcessConcurrentCommitActivateNoDuplicateTest.access$000(DurableSubProcessConcurrentCommitActivateNoDuplicateTest.this).readLock().lock();
                        try {
                            this.sweep();
                        }
                        finally {
                            DurableSubProcessConcurrentCommitActivateNoDuplicateTest.access$000(DurableSubProcessConcurrentCommitActivateNoDuplicateTest.this).readLock().unlock();
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException ex) {
                    break;
                }
                catch (Throwable e) {
                    log = new Exception("HouseKeeper failed.", e);
                    log.printStackTrace();
                    continue;
                }
                ** GOTO lbl-1000
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sweep() throws Exception {
            LOG.info("Housekeeper sweeping.");
            int closed = 0;
            ArrayList<String> sweeped = new ArrayList<String>();
            try {
                for (String clientId : this.abandonedSubscriptions) {
                    LOG.info("Sweeping out subscription of " + clientId + ".");
                    DurableSubProcessConcurrentCommitActivateNoDuplicateTest.this.broker.getAdminView().destroyDurableSubscriber(clientId, "subscription");
                    sweeped.add(clientId);
                    ++closed;
                }
            }
            catch (Exception ignored) {
                LOG.info("Ex on destroy sub " + ignored);
            }
            finally {
                this.abandonedSubscriptions.removeAll(sweeped);
            }
            LOG.info("Housekeeper sweeped out " + closed + " subscriptions.");
        }
    }

    private final class Client
    extends Thread {
        String url;
        final ConnectionFactory cf;
        public static final String SUBSCRIPTION_NAME = "subscription";
        private final int id;
        private final String conClientId;
        private final Random lifetime;
        private final Random online;
        private final Random offline;
        private final ClientType clientType;
        private final String selector;
        private final ConcurrentLinkedQueue<Message> waitingList;
        private final HashSet<Integer> processed;
        private ActiveMQMessageConsumer consumer;

        public Client(int id, ClientType clientType, Random lifetime, Random online, Random offline) throws JMSException {
            super("Client" + id);
            this.url = "failover:(tcp://localhost:61656?wireFormat.maxInactivityDuration=0)?jms.watchTopicAdvisories=false&jms.alwaysSyncSend=true&jms.dispatchAsync=true&jms.producerWindowSize=20971520&jms.copyMessageOnSend=false&jms.sendAcksAsync=false&initialReconnectDelay=100&maxReconnectDelay=30000&useExponentialBackOff=true";
            this.cf = new ActiveMQConnectionFactory(this.url);
            this.waitingList = new ConcurrentLinkedQueue();
            this.processed = new HashSet(10000);
            this.consumer = null;
            this.setDaemon(true);
            this.id = id;
            this.conClientId = "cli" + id;
            this.clientType = clientType;
            this.selector = "(COMMIT = true and RELEVANT = true) or " + clientType.selector;
            this.lifetime = lifetime;
            this.online = online;
            this.offline = offline;
            this.subscribe();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long end = System.currentTimeMillis() + 60000L;
            try {
                long max;
                boolean sleep = false;
                while ((max = end - System.currentTimeMillis()) > 0L) {
                    Thread.sleep(100L);
                    DurableSubProcessConcurrentCommitActivateNoDuplicateTest.this.processLock.readLock().lock();
                    DurableSubProcessConcurrentCommitActivateNoDuplicateTest.this.onlineCount.incrementAndGet();
                    try {
                        this.process(this.online.next());
                    }
                    finally {
                        DurableSubProcessConcurrentCommitActivateNoDuplicateTest.this.onlineCount.decrementAndGet();
                        DurableSubProcessConcurrentCommitActivateNoDuplicateTest.this.processLock.readLock().unlock();
                    }
                }
                if (DurableSubProcessConcurrentCommitActivateNoDuplicateTest.random(1) > 0) {
                    this.unsubscribe();
                } else {
                    LOG.info("Client abandon the subscription. " + this);
                    ((DurableSubProcessConcurrentCommitActivateNoDuplicateTest)DurableSubProcessConcurrentCommitActivateNoDuplicateTest.this).houseKeeper.abandonedSubscriptions.add(this.conClientId);
                }
            }
            catch (Throwable e) {
                DurableSubProcessConcurrentCommitActivateNoDuplicateTest.exit(this.toString() + " failed.", e);
            }
            DurableSubProcessConcurrentCommitActivateNoDuplicateTest.this.clientManager.removeClient(this);
            LOG.info(this.toString() + " DONE.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void process(long millis) throws JMSException {
            long end = System.currentTimeMillis() + 200L;
            long hardEnd = end + 20000L;
            boolean inTransaction = false;
            int transCount = 0;
            Connection con = this.openConnection();
            Session sess = con.createSession(false, 2);
            this.consumer = (ActiveMQMessageConsumer)sess.createDurableSubscriber((Topic)DurableSubProcessConcurrentCommitActivateNoDuplicateTest.this.topic, SUBSCRIPTION_NAME, this.selector, false);
            LOG.info(this.toString() + " ONLINE.");
            try {
                while (true) {
                    Message message;
                    long max;
                    if ((max = end - System.currentTimeMillis()) <= 0L) {
                        if (!inTransaction) {
                            LOG.info(this.toString() + " done after no work!");
                            break;
                        }
                        max = hardEnd - System.currentTimeMillis();
                        if (max <= 0L) {
                            DurableSubProcessConcurrentCommitActivateNoDuplicateTest.exit("" + this + " failed: Transaction is not finished.");
                        }
                    }
                    if ((message = this.consumer.receive(max)) == null) continue;
                    this.onClientMessage(message);
                    if (message.propertyExists("COMMIT")) {
                        message.acknowledge();
                        int trans = message.getIntProperty("TRANS");
                        LOG.info("Received Trans[id=" + trans + ", count=" + transCount + "] in " + this + ".");
                        inTransaction = false;
                        transCount = 0;
                        int committing = ((DurableSubProcessConcurrentCommitActivateNoDuplicateTest)DurableSubProcessConcurrentCommitActivateNoDuplicateTest.this).server.committingTransaction;
                        if (committing != trans) continue;
                        LOG.info("Going offline during transaction commit. messageID=" + message.getIntProperty("ID"));
                        break;
                    }
                    inTransaction = true;
                    if (1 != ++transCount) continue;
                    LOG.info("In Trans[id=" + message.getIntProperty("TRANS") + "] first ID=" + message.getIntProperty("ID"));
                }
            }
            finally {
                sess.close();
                con.close();
                LOG.info(this.toString() + " OFFLINE.");
                Message topMessage = this.waitingList.peek();
                if (topMessage != null) {
                    this.checkDeliveryTime(topMessage);
                }
            }
        }

        public void onServerMessage(Message message) throws JMSException {
            if (Boolean.TRUE.equals(message.getObjectProperty("COMMIT"))) {
                if (Boolean.TRUE.equals(message.getObjectProperty("RELEVANT"))) {
                    this.waitingList.add(message);
                }
            } else {
                String messageType = message.getStringProperty("TYPE");
                if (this.clientType.isRelevant(messageType)) {
                    this.waitingList.add(message);
                }
            }
        }

        public void onClientMessage(Message message) {
            Message serverMessage = this.waitingList.poll();
            try {
                Integer receivedId = (Integer)message.getObjectProperty("ID");
                if (this.processed != null && this.processed.contains(receivedId)) {
                    LOG.info("! Message has been processed before. " + this + " redeliveredFlag=" + message.getJMSRedelivered() + ", message = " + message);
                }
                if (serverMessage == null) {
                    DurableSubProcessConcurrentCommitActivateNoDuplicateTest.exit("" + this + " failed: There is no next server message, but received: " + message);
                }
                Integer serverId = (Integer)serverMessage.getObjectProperty("ID");
                if (receivedId == null || serverId == null) {
                    DurableSubProcessConcurrentCommitActivateNoDuplicateTest.exit("" + this + " failed: message ID not found.\r\n" + " received: " + message + "\r\n" + "   server: " + serverMessage);
                }
                if (!serverId.equals(receivedId)) {
                    StringBuilder missingList = new StringBuilder();
                    Object lastTrans = null;
                    int transCount = 0;
                    Message nextServerMessage = serverMessage;
                    do {
                        Integer nextServerId;
                        if ((nextServerId = (Integer)nextServerMessage.getObjectProperty("ID")).equals(receivedId)) {
                            if (lastTrans == null) break;
                            missingList.append("Missing TRANS=").append(lastTrans).append(", size=").append(transCount).append("\r\n");
                            break;
                        }
                        Object trans = nextServerMessage.getObjectProperty("TRANS");
                        if (!trans.equals(lastTrans)) {
                            if (lastTrans != null) {
                                missingList.append("Missing TRANS=").append(lastTrans).append(", size=").append(transCount).append("\r\n");
                            }
                            lastTrans = trans;
                            transCount = 1;
                            continue;
                        }
                        ++transCount;
                    } while ((nextServerMessage = this.waitingList.poll()) != null);
                    DurableSubProcessConcurrentCommitActivateNoDuplicateTest.exit("Missing messages!\r\n" + missingList + "Received message: " + message + "\r\n" + "Expected message: " + serverMessage);
                }
                this.checkDeliveryTime(message);
                if (this.processed != null) {
                    this.processed.add(receivedId);
                }
            }
            catch (Throwable e) {
                DurableSubProcessConcurrentCommitActivateNoDuplicateTest.exit("" + this + ".onClientMessage failed.\r\n" + " received: " + message + "\r\n" + "   server: " + serverMessage, e);
            }
        }

        public void checkDeliveryTime(Message message) throws JMSException {
            long creation = message.getJMSTimestamp();
            long min = System.currentTimeMillis() - (long)((this.offline.max + this.online.min) * 1);
        }

        private Connection openConnection() throws JMSException {
            Connection con = this.cf.createConnection();
            con.setClientID(this.conClientId);
            ((ActiveMQConnection)con).setCloseTimeout(60000);
            con.start();
            return con;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void subscribe() throws JMSException {
            DurableSubProcessConcurrentCommitActivateNoDuplicateTest.this.processLock.readLock().lock();
            try {
                Connection con = this.openConnection();
                Session session = con.createSession(false, 1);
                session.createDurableSubscriber((Topic)DurableSubProcessConcurrentCommitActivateNoDuplicateTest.this.topic, SUBSCRIPTION_NAME, this.selector, true);
                session.close();
                con.close();
            }
            finally {
                DurableSubProcessConcurrentCommitActivateNoDuplicateTest.this.processLock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unsubscribe() throws JMSException {
            DurableSubProcessConcurrentCommitActivateNoDuplicateTest.this.processLock.readLock().lock();
            LOG.info("Unsubscribe: " + this);
            try {
                Connection con = this.openConnection();
                Session session = con.createSession(false, 1);
                session.unsubscribe(SUBSCRIPTION_NAME);
                session.close();
                con.close();
            }
            finally {
                DurableSubProcessConcurrentCommitActivateNoDuplicateTest.this.processLock.readLock().unlock();
            }
        }

        @Override
        public String toString() {
            return "Client[id=" + this.id + ", type=" + (Object)((Object)this.clientType) + "] consumerId=" + (this.consumer != null ? this.consumer.getConsumerId() : "null");
        }
    }

    private final class ClientManager
    extends Thread {
        private int clientRover;
        private final CopyOnWriteArrayList<Client> clients;
        private boolean end;

        public ClientManager() {
            super("ClientManager");
            this.clientRover = 0;
            this.clients = new CopyOnWriteArrayList();
            this.setDaemon(true);
        }

        public synchronized void setEnd(boolean end) {
            this.end = end;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (true) {
                    if (this.clients.size() < 2 && !this.end) {
                        DurableSubProcessConcurrentCommitActivateNoDuplicateTest.this.processLock.readLock().lock();
                        try {
                            this.createNewClient();
                        }
                        finally {
                            DurableSubProcessConcurrentCommitActivateNoDuplicateTest.this.processLock.readLock().unlock();
                        }
                    }
                    int size = this.clients.size();
                    Thread.sleep(100L);
                }
            }
            catch (Throwable e) {
                DurableSubProcessConcurrentCommitActivateNoDuplicateTest.exit("ClientManager.run failed.", e);
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void createNewClient() throws JMSException {
            Client client;
            ClientType type = ClientType.randomClientType();
            Object object = ((DurableSubProcessConcurrentCommitActivateNoDuplicateTest)DurableSubProcessConcurrentCommitActivateNoDuplicateTest.this).server.sendMutex;
            synchronized (object) {
                client = new Client(++this.clientRover, type, CLIENT_LIFETIME, CLIENT_ONLINE, CLIENT_OFFLINE);
                this.clients.add(client);
            }
            client.start();
            LOG.info(client.toString() + " created. " + this);
        }

        public void removeClient(Client client) {
            this.clients.remove(client);
        }

        public void onServerMessage(Message message) throws JMSException {
            for (Client client : this.clients) {
                client.onServerMessage(message);
            }
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("ClientManager[count=");
            sb.append(this.clients.size());
            sb.append(", clients=");
            boolean sep = false;
            for (Client client : this.clients) {
                if (sep) {
                    sb.append(", ");
                } else {
                    sep = true;
                }
                sb.append(client.toString());
            }
            sb.append(']');
            return sb.toString();
        }
    }

    private static enum ClientType {
        A("a", "b", "c"),
        B("c", "d", "e"),
        C("d", "e", "f"),
        D("g", "h");

        public final String[] messageTypes;
        public final HashSet<String> messageTypeSet;
        public final String selector;

        private ClientType(String ... messageTypes) {
            this.messageTypes = messageTypes;
            this.messageTypeSet = new HashSet<String>(Arrays.asList(messageTypes));
            StringBuilder sb = new StringBuilder("TYPE in (");
            for (int i = 0; i < messageTypes.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append('\'').append(messageTypes[i]).append('\'');
            }
            sb.append(')');
            this.selector = sb.toString();
        }

        public static ClientType randomClientType() {
            return ClientType.values()[DurableSubProcessConcurrentCommitActivateNoDuplicateTest.random(ClientType.values().length - 1)];
        }

        public final String randomMessageType() {
            return this.messageTypes[DurableSubProcessConcurrentCommitActivateNoDuplicateTest.random(this.messageTypes.length - 1)];
        }

        public static String randomNonRelevantMessageType() {
            return Integer.toString(DurableSubProcessConcurrentCommitActivateNoDuplicateTest.random(20));
        }

        public final boolean isRelevant(String messageType) {
            return this.messageTypeSet.contains(messageType);
        }

        public final String toString() {
            return this.name();
        }
    }

    final class Server
    extends Thread {
        final String url;
        final ConnectionFactory cf;
        final Object sendMutex;
        final String[] cargos;
        int transRover;
        int messageRover;
        public volatile int committingTransaction;
        public boolean done;

        public Server() {
            super("Server");
            this.url = "vm://" + DurableSubProcessConcurrentCommitActivateNoDuplicateTest.getName() + "?" + "jms.redeliveryPolicy.maximumRedeliveries=2&jms.redeliveryPolicy.initialRedeliveryDelay=500&" + "jms.producerWindowSize=20971520&jms.prefetchPolicy.all=100&" + "jms.copyMessageOnSend=false&jms.disableTimeStampsByDefault=false&" + "jms.alwaysSyncSend=true&jms.dispatchAsync=false&" + "jms.watchTopicAdvisories=false&" + "waitForStart=200&create=false";
            this.cf = new ActiveMQConnectionFactory(this.url);
            this.sendMutex = new Object();
            this.cargos = new String[500];
            this.transRover = 0;
            this.messageRover = 0;
            this.committingTransaction = -1;
            this.done = false;
            this.setPriority(1);
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (!this.done) {
                    Thread.sleep(1000L);
                    DurableSubProcessConcurrentCommitActivateNoDuplicateTest.this.processLock.readLock().lock();
                    try {
                        this.send();
                    }
                    finally {
                        DurableSubProcessConcurrentCommitActivateNoDuplicateTest.this.processLock.readLock().unlock();
                    }
                }
            }
            catch (Throwable e) {
                DurableSubProcessConcurrentCommitActivateNoDuplicateTest.exit("Server.run failed", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void send() throws JMSException {
            Object object = this.sendMutex;
            synchronized (object) {
                int trans = ++this.transRover;
                boolean relevantTrans = true;
                ClientType clientType = relevantTrans ? ClientType.randomClientType() : null;
                int count = 1000;
                LOG.info("Sending Trans[id=" + trans + ", count=" + count + ", clientType=" + (Object)((Object)clientType) + ", firstID=" + (this.messageRover + 1) + "]");
                Connection con = this.cf.createConnection();
                Session sess = con.createSession(true, 0);
                MessageProducer prod = sess.createProducer(null);
                for (int i = 0; i < count; ++i) {
                    Message message = sess.createMessage();
                    message.setIntProperty("ID", ++this.messageRover);
                    message.setIntProperty("TRANS", trans);
                    String type = clientType != null ? clientType.randomMessageType() : ClientType.randomNonRelevantMessageType();
                    message.setStringProperty("TYPE", type);
                    message.setStringProperty("CARGO", this.getCargo(DurableSubProcessConcurrentCommitActivateNoDuplicateTest.random(600)));
                    prod.send((Destination)DurableSubProcessConcurrentCommitActivateNoDuplicateTest.this.topic, message);
                    DurableSubProcessConcurrentCommitActivateNoDuplicateTest.this.clientManager.onServerMessage(message);
                }
                Message message = sess.createMessage();
                message.setIntProperty("ID", ++this.messageRover);
                message.setIntProperty("TRANS", trans);
                message.setBooleanProperty("COMMIT", true);
                message.setBooleanProperty("RELEVANT", relevantTrans);
                prod.send((Destination)DurableSubProcessConcurrentCommitActivateNoDuplicateTest.this.topic, message);
                DurableSubProcessConcurrentCommitActivateNoDuplicateTest.this.clientManager.onServerMessage(message);
                this.committingTransaction = trans;
                sess.commit();
                this.committingTransaction = -1;
                LOG.info("Committed Trans[id=" + trans + ", count=" + count + ", clientType=" + (Object)((Object)clientType) + "], ID=" + this.messageRover);
                sess.close();
                con.close();
            }
        }

        private String getCargo(int length) {
            if (length == 0) {
                return null;
            }
            if (length < this.cargos.length) {
                String result = this.cargos[length];
                if (result == null) {
                    this.cargos[length] = result = this.getCargoImpl(length);
                }
                return result;
            }
            return this.getCargoImpl(length);
        }

        private String getCargoImpl(int length) {
            StringBuilder sb = new StringBuilder(length);
            int i = length;
            while (--i >= 0) {
                sb.append('a');
            }
            return sb.toString();
        }
    }
}

