/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.network.DemandForwardingBridgeSupport;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.usecases.TwoBrokerTopicSendReceiveTest;
import org.apache.activemq.util.Wait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwoBrokerQueueSendReceiveTest
extends TwoBrokerTopicSendReceiveTest {
    private static final Logger LOG = LoggerFactory.getLogger(TwoBrokerQueueSendReceiveTest.class);

    @Override
    protected void setUp() throws Exception {
        this.setAutoFail(true);
        this.setMaxTestTime(60000L);
        this.topic = false;
        super.setUp();
    }

    public void testReceiveOnXConsumersNoLeak() throws Exception {
        this.consumer.close();
        this.sendMessages();
        for (int i = 0; i < this.data.length; ++i) {
            this.consumer = this.createConsumer();
            this.onMessage(this.consumer.receive(10000L));
            this.consumer.close();
        }
        this.waitForMessagesToBeDelivered();
        TwoBrokerQueueSendReceiveTest.assertEquals((String)"Got all messages", (int)this.data.length, (int)this.messages.size());
        BrokerService broker = (BrokerService)this.brokers.get("receiver");
        final DemandForwardingBridgeSupport bridge = (DemandForwardingBridgeSupport)((NetworkConnector)broker.getNetworkConnectors().get(0)).activeBridges().toArray()[0];
        TwoBrokerQueueSendReceiveTest.assertTrue((String)("No extra, size:" + bridge.getLocalSubscriptionMap().size()), (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                LOG.info("local subs map size = " + bridge.getLocalSubscriptionMap().size());
                return 0 == bridge.getLocalSubscriptionMap().size();
            }
        }));
    }
}

