/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.scheduler;

import java.io.File;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.Session;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.util.IOHelper;
import org.apache.activemq.util.ProducerThread;

public class JobSchedulerBrokerShutdownTest
extends EmbeddedBrokerTestSupport {
    @Override
    protected BrokerService createBroker() throws Exception {
        File schedulerDirectory = new File("target/scheduler");
        IOHelper.mkdirs((File)schedulerDirectory);
        IOHelper.deleteChildren((File)schedulerDirectory);
        BrokerService broker = super.createBroker();
        broker.setSchedulerSupport(true);
        broker.setSchedulerDirectoryFile(schedulerDirectory);
        broker.getSystemUsage().getStoreUsage().setLimit(512L);
        broker.deleteAllMessages();
        return broker;
    }

    @Override
    protected boolean isPersistent() {
        return true;
    }

    public void testSchedule() throws Exception {
        Connection connection = this.createConnection();
        Session session = connection.createSession(false, 1);
        connection.start();
        long time = 1000L;
        ProducerThread producer = new ProducerThread(session, (Destination)this.destination){

            @Override
            protected Message createMessage(int i) throws Exception {
                Message message = super.createMessage(i);
                message.setLongProperty("AMQ_SCHEDULED_DELAY", 1000L);
                return message;
            }
        };
        producer.setMessageCount(200);
        producer.setDaemon(true);
        producer.start();
        Thread.sleep(5000L);
    }
}

