/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.jmx;

import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.OpenTypeSupport;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.apache.activemq.command.ActiveMQBytesMessage;
import org.apache.activemq.command.ActiveMQQueue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenTypeSupportTest {
    private static final Logger LOG = LoggerFactory.getLogger(OpenTypeSupportTest.class);
    private static BrokerService brokerService;
    private static String TESTQUEUE;
    private static ActiveMQConnectionFactory connectionFactory;
    private static String BYTESMESSAGE_TEXT;
    private static String BROKER_ADDRESS;
    private static ActiveMQQueue queue;
    private String connectionUri;

    @Before
    public void setUp() throws Exception {
        brokerService = new BrokerService();
        brokerService.setPersistent(false);
        brokerService.setUseJmx(true);
        this.connectionUri = brokerService.addConnector(BROKER_ADDRESS).getPublishableConnectString();
        brokerService.start();
        connectionFactory = new ActiveMQConnectionFactory(this.connectionUri);
        OpenTypeSupportTest.sendMessage();
    }

    @After
    public void tearDown() throws Exception {
        brokerService.stop();
        brokerService.waitUntilStopped();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendMessage() throws JMSException {
        Connection conn = connectionFactory.createConnection();
        try {
            conn.start();
            Session session = conn.createSession(false, 1);
            Queue queue = session.createQueue(TESTQUEUE);
            BytesMessage toSend = session.createBytesMessage();
            toSend.writeBytes(BYTESMESSAGE_TEXT.getBytes());
            MessageProducer producer = session.createProducer((Destination)queue);
            producer.send((Destination)queue, (Message)toSend);
        }
        finally {
            conn.close();
        }
    }

    @Test
    public void bytesMessagePreview() throws Exception {
        QueueViewMBean queue = this.getProxyToQueueViewMBean();
        Assert.assertEquals((Object)this.extractText(queue.browse()[0]), (Object)this.extractText(queue.browse()[0]));
    }

    @Test
    public void testBrowseByteMessageFails() throws Exception {
        ActiveMQBytesMessage bm = new ActiveMQBytesMessage();
        bm.writeBytes("123456".getBytes());
        CompositeData result = OpenTypeSupport.convert((Object)bm);
        LOG.info("result : " + result);
    }

    private String extractText(CompositeData message) {
        Byte[] content = (Byte[])message.get("BodyPreview");
        byte[] out = new byte[content.length];
        for (int i = 0; i < content.length; ++i) {
            out[i] = content[i];
        }
        return new String(out);
    }

    private QueueViewMBean getProxyToQueueViewMBean() throws MalformedObjectNameException, JMSException {
        ObjectName queueViewMBeanName = new ObjectName("org.apache.activemq:type=Broker,brokerName=localhost,destinationType=Queue,destinationName=" + queue.getQueueName());
        QueueViewMBean proxy = (QueueViewMBean)brokerService.getManagementContext().newProxyInstance(queueViewMBeanName, QueueViewMBean.class, true);
        return proxy;
    }

    static {
        TESTQUEUE = "testQueue";
        BYTESMESSAGE_TEXT = "This is a short text";
        BROKER_ADDRESS = "tcp://localhost:0";
        queue = new ActiveMQQueue(TESTQUEUE);
    }
}

