/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.security;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifFiles;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.ldap.LdapServer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP", port=1024)})
@ApplyLdifFiles(value={"org/apache/activemq/security/activemq.ldif"})
public class LDAPSecurityTest
extends AbstractLdapTestUnit {
    public BrokerService broker;
    public static LdapServer ldapServer;

    @Before
    public void setup() throws Exception {
        System.setProperty("ldapPort", String.valueOf(LDAPSecurityTest.getLdapServer().getPort()));
        this.broker = BrokerFactory.createBroker((String)"xbean:org/apache/activemq/security/activemq-ldap.xml");
        this.broker.start();
        this.broker.waitUntilStarted();
    }

    @After
    public void shutdown() throws Exception {
        this.broker.stop();
        this.broker.waitUntilStopped();
    }

    @Test
    public void testSendReceive() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("tcp://localhost:61616");
        QueueConnection conn = factory.createQueueConnection("jdoe", "sunflower");
        Session sess = conn.createSession(false, 1);
        conn.start();
        Queue queue = sess.createQueue("TEST.FOO");
        MessageProducer producer = sess.createProducer((Destination)queue);
        MessageConsumer consumer = sess.createConsumer((Destination)queue);
        producer.send((Message)sess.createTextMessage("test"));
        Message msg = consumer.receive(1000L);
        Assert.assertNotNull((Object)msg);
    }

    @Test
    public void testSendDenied() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("tcp://localhost:61616");
        QueueConnection conn = factory.createQueueConnection("jdoe", "sunflower");
        Session sess = conn.createSession(false, 1);
        conn.start();
        Queue queue = sess.createQueue("ADMIN.FOO");
        try {
            MessageProducer producer = sess.createProducer((Destination)queue);
            producer.send((Message)sess.createTextMessage("test"));
            Assert.fail((String)"expect auth exception");
        }
        catch (JMSException expected) {
            // empty catch block
        }
    }

    @Test
    public void testCompositeSendDenied() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("tcp://localhost:61616");
        QueueConnection conn = factory.createQueueConnection("jdoe", "sunflower");
        Session sess = conn.createSession(false, 1);
        conn.start();
        Queue queue = sess.createQueue("TEST.FOO,ADMIN.FOO");
        try {
            MessageProducer producer = sess.createProducer((Destination)queue);
            producer.send((Message)sess.createTextMessage("test"));
            Assert.fail((String)"expect auth exception");
        }
        catch (JMSException expected) {
            // empty catch block
        }
    }

    @Test
    public void testTempDestinations() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("tcp://localhost:61616");
        QueueConnection conn = factory.createQueueConnection("jdoe", "sunflower");
        Session sess = conn.createSession(false, 1);
        conn.start();
        TemporaryQueue queue = sess.createTemporaryQueue();
        MessageProducer producer = sess.createProducer((Destination)queue);
        MessageConsumer consumer = sess.createConsumer((Destination)queue);
        producer.send((Message)sess.createTextMessage("test"));
        Message msg = consumer.receive(1000L);
        Assert.assertNotNull((Object)msg);
    }
}

