/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store;

import java.io.File;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.store.SharedFileLocker;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class SharedFileLockerTest {
    @Rule
    public TemporaryFolder testFolder = new TemporaryFolder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLock() throws Exception {
        final AtomicInteger errors = new AtomicInteger(0);
        Thread thread = null;
        SharedFileLocker locker1 = new SharedFileLocker();
        locker1.setDirectory(this.testFolder.getRoot());
        final SharedFileLocker locker2 = new SharedFileLocker();
        locker2.setLockAcquireSleepInterval(1L);
        locker2.setDirectory(this.testFolder.getRoot());
        try {
            locker1.doStart();
            Assert.assertTrue((boolean)locker1.keepAlive());
            Thread.sleep(10L);
            thread = new Thread("Locker Thread"){

                @Override
                public void run() {
                    try {
                        locker2.doStart();
                    }
                    catch (Throwable e) {
                        errors.incrementAndGet();
                    }
                }
            };
            thread.start();
            Thread.sleep(100L);
            Assert.assertTrue((boolean)thread.isAlive());
            locker1.stop();
            thread.join(5000L);
            long timeout = System.currentTimeMillis() + 5000L;
            while (timeout > System.currentTimeMillis() && !locker2.keepAlive()) {
                Thread.sleep(1L);
            }
            Assert.assertTrue((boolean)locker2.keepAlive());
            locker2.stop();
        }
        finally {
            thread.join(1000L);
            if (thread.isAlive()) {
                thread.interrupt();
            }
            File lockFile = new File(this.testFolder.getRoot(), "lock");
            lockFile.delete();
        }
    }
}

