/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.security;

import java.io.InputStream;
import org.apache.activemq.security.AbstractCachedLDAPAuthorizationModuleTest;
import org.apache.activemq.security.SimpleCachedLDAPAuthorizationMap;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifFiles;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP")})
@ApplyLdifFiles(value={"org/apache/activemq/security/activemq-apacheds.ldif"})
public class CachedLDAPAuthorizationModuleTest
extends AbstractCachedLDAPAuthorizationModuleTest {
    @Override
    protected SimpleCachedLDAPAuthorizationMap createMap() {
        SimpleCachedLDAPAuthorizationMap map = super.createMap();
        map.setConnectionURL("ldap://localhost:" + CachedLDAPAuthorizationModuleTest.getLdapServer().getPort());
        return map;
    }

    @Override
    protected InputStream getAddLdif() {
        return ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/apache/activemq/security/activemq-apacheds-add.ldif");
    }

    @Override
    protected InputStream getRemoveLdif() {
        return ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/apache/activemq/security/activemq-apacheds-delete.ldif");
    }

    @Override
    protected String getMemberAttributeValueForModifyRequest() {
        return "cn=users,ou=Group,ou=ActiveMQ,ou=system";
    }

    @Override
    protected String getQueueBaseDn() {
        return "ou=Queue,ou=Destination,ou=ActiveMQ,ou=system";
    }

    @Override
    protected LdapConnection getLdapConnection() throws Exception {
        LdapNetworkConnection connection = new LdapNetworkConnection("localhost", CachedLDAPAuthorizationModuleTest.getLdapServer().getPort());
        connection.bind(new Dn(new String[]{"uid=admin,ou=system"}), "secret");
        return connection;
    }
}

