/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.udp;

import java.io.IOException;
import javax.jms.MessageNotWriteableException;
import junit.framework.TestCase;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.Response;
import org.apache.activemq.command.WireFormatInfo;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportAcceptListener;
import org.apache.activemq.transport.TransportListener;
import org.apache.activemq.transport.TransportServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UdpTestSupport
extends TestCase
implements TransportListener {
    private static final Logger LOG = LoggerFactory.getLogger(UdpTestSupport.class);
    protected Transport producer;
    protected Transport consumer;
    protected Object lock = new Object();
    protected Command receivedCommand;
    protected TransportServer server;
    protected boolean large;
    protected int waitForCommandTimeout = 40000;

    public void testSendingSmallMessage() throws Exception {
        ConsumerInfo expected = new ConsumerInfo();
        expected.setSelector("Cheese");
        expected.setExclusive(true);
        expected.setExclusive(true);
        expected.setPrefetchSize(3456);
        try {
            LOG.info("About to send: " + expected);
            this.producer.oneway((Object)expected);
            Command received = this.assertCommandReceived();
            UdpTestSupport.assertTrue((String)("Should have received a ConsumerInfo but was: " + received), (boolean)(received instanceof ConsumerInfo));
            ConsumerInfo actual = (ConsumerInfo)received;
            UdpTestSupport.assertEquals((String)"Selector", (String)expected.getSelector(), (String)actual.getSelector());
            UdpTestSupport.assertEquals((String)"isExclusive", (boolean)expected.isExclusive(), (boolean)actual.isExclusive());
            UdpTestSupport.assertEquals((String)"getPrefetchSize", (int)expected.getPrefetchSize(), (int)actual.getPrefetchSize());
        }
        catch (Exception e) {
            LOG.info("Caught: " + e);
            e.printStackTrace();
            UdpTestSupport.fail((String)("Failed to send to transport: " + e));
        }
    }

    public void testSendingMediumMessage() throws Exception {
        String text = this.createMessageBodyText(420);
        ActiveMQQueue destination = new ActiveMQQueue("Foo.Bar.Medium");
        this.assertSendTextMessage((ActiveMQDestination)destination, text);
    }

    public void testSendingLargeMessage() throws Exception {
        String text = this.createMessageBodyText(4096);
        ActiveMQQueue destination = new ActiveMQQueue("Foo.Bar.Large");
        this.assertSendTextMessage((ActiveMQDestination)destination, text);
    }

    protected void assertSendTextMessage(ActiveMQDestination destination, String text) throws MessageNotWriteableException {
        this.large = true;
        ActiveMQTextMessage expected = new ActiveMQTextMessage();
        expected.setText(text);
        expected.setDestination(destination);
        try {
            LOG.info("About to send message of type: " + expected.getClass());
            this.producer.oneway((Object)expected);
            this.producer.oneway((Object)new ProducerInfo());
            this.producer.oneway((Object)new ProducerInfo());
            Command received = this.assertCommandReceived();
            UdpTestSupport.assertTrue((String)("Should have received a ActiveMQTextMessage but was: " + received), (boolean)(received instanceof ActiveMQTextMessage));
            ActiveMQTextMessage actual = (ActiveMQTextMessage)received;
            UdpTestSupport.assertEquals((String)"getDestination", (Object)expected.getDestination(), (Object)actual.getDestination());
            UdpTestSupport.assertEquals((String)"getText", (String)expected.getText(), (String)actual.getText());
            LOG.info("Received text message with: " + actual.getText().length() + " character(s)");
        }
        catch (Exception e) {
            LOG.info("Caught: " + e);
            e.printStackTrace();
            UdpTestSupport.fail((String)("Failed to send to transport: " + e));
        }
    }

    protected String createMessageBodyText(int loopSize) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < loopSize; ++i) {
            buffer.append("0123456789");
        }
        return buffer.toString();
    }

    protected void setUp() throws Exception {
        this.server = this.createServer();
        if (this.server != null) {
            this.server.setAcceptListener(new TransportAcceptListener(){

                public void onAccept(Transport transport) {
                    UdpTestSupport.this.consumer = transport;
                    UdpTestSupport.this.consumer.setTransportListener((TransportListener)UdpTestSupport.this);
                    try {
                        UdpTestSupport.this.consumer.start();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                public void onAcceptError(Exception error) {
                }
            });
            this.server.start();
        }
        this.consumer = this.createConsumer();
        if (this.consumer != null) {
            this.consumer.setTransportListener((TransportListener)this);
            this.consumer.start();
        }
        this.producer = this.createProducer();
        this.producer.setTransportListener(new TransportListener(){

            public void onCommand(Object command) {
                LOG.info("Producer received: " + command);
            }

            public void onException(IOException error) {
                LOG.info("Producer exception: " + error);
                error.printStackTrace();
            }

            public void transportInterupted() {
            }

            public void transportResumed() {
            }
        });
        this.producer.start();
    }

    protected void tearDown() throws Exception {
        if (this.producer != null) {
            this.producer.stop();
        }
        if (this.consumer != null) {
            this.consumer.stop();
        }
        if (this.server != null) {
            this.server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCommand(Object o) {
        Command command = (Command)o;
        if (command instanceof WireFormatInfo) {
            LOG.info("Got WireFormatInfo: " + command);
        } else {
            if (command.isResponseRequired()) {
                this.sendResponse(command);
            }
            if (this.large) {
                LOG.info("### Received command: " + command.getClass() + " with id: " + command.getCommandId());
            } else {
                LOG.info("### Received command: " + command);
            }
            Object object = this.lock;
            synchronized (object) {
                if (this.receivedCommand == null) {
                    this.receivedCommand = command;
                } else {
                    LOG.info("Ignoring superfluous command: " + command);
                }
                this.lock.notifyAll();
            }
        }
    }

    protected void sendResponse(Command command) {
        Response response = new Response();
        response.setCorrelationId(command.getCommandId());
        try {
            this.consumer.oneway((Object)response);
        }
        catch (IOException e) {
            LOG.info("Caught: " + e);
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void onException(IOException error) {
        LOG.info("### Received error: " + error);
        error.printStackTrace();
    }

    public void transportInterupted() {
        LOG.info("### Transport interrupted");
    }

    public void transportResumed() {
        LOG.info("### Transport resumed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Command assertCommandReceived() throws InterruptedException {
        Command answer = null;
        Object object = this.lock;
        synchronized (object) {
            answer = this.receivedCommand;
            if (answer == null) {
                this.lock.wait(this.waitForCommandTimeout);
            }
            answer = this.receivedCommand;
        }
        UdpTestSupport.assertNotNull((String)"Should have received a Command by now!", (Object)answer);
        return answer;
    }

    protected abstract Transport createConsumer() throws Exception;

    protected abstract Transport createProducer() throws Exception;

    protected TransportServer createServer() throws Exception {
        return null;
    }
}

