/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQTopic;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TopicSubscriptionZeroPrefetchTest {
    private static final String TOPIC_NAME = "slow.consumer";
    private Connection connection;
    private Session session;
    private ActiveMQTopic destination;
    private MessageProducer producer;
    private MessageConsumer consumer;
    private BrokerService brokerService;

    @Before
    public void setUp() throws Exception {
        this.brokerService = this.createBroker();
        ActiveMQConnectionFactory activeMQConnectionFactory = new ActiveMQConnectionFactory("vm://localhost");
        activeMQConnectionFactory.setWatchTopicAdvisories(true);
        this.connection = activeMQConnectionFactory.createConnection();
        this.connection.setClientID("ClientID-1");
        this.session = this.connection.createSession(false, 1);
        this.destination = new ActiveMQTopic(TOPIC_NAME);
        this.producer = this.session.createProducer((Destination)this.destination);
        this.connection.start();
    }

    @Test(timeout=60000L)
    public void testTopicConsumerPrefetchZero() throws Exception {
        ActiveMQTopic consumerDestination = new ActiveMQTopic("slow.consumer?consumer.retroactive=true&consumer.prefetchSize=0");
        this.consumer = this.session.createConsumer((Destination)consumerDestination);
        TextMessage txtMessage = this.session.createTextMessage("M");
        this.producer.send((Message)txtMessage);
        Message consumedMessage = this.consumer.receiveNoWait();
        Assert.assertNotNull((String)"should have received a message the published message", (Object)consumedMessage);
    }

    @Test(timeout=60000L)
    public void testDurableTopicConsumerPrefetchZero() throws Exception {
        ActiveMQTopic consumerDestination = new ActiveMQTopic("slow.consumer?consumer.prefetchSize=0");
        this.consumer = this.session.createDurableSubscriber((Topic)consumerDestination, "mysub1");
        TextMessage txtMessage = this.session.createTextMessage("M");
        this.producer.send((Message)txtMessage);
        Message consumedMessage = this.consumer.receive(100L);
        Assert.assertNotNull((String)"should have received a message the published message", (Object)consumedMessage);
    }

    @After
    public void tearDown() throws Exception {
        this.consumer.close();
        this.producer.close();
        this.session.close();
        this.connection.close();
        this.brokerService.stop();
    }

    private BrokerService createBroker() throws Exception {
        BrokerService broker = new BrokerService();
        broker.setBrokerName("localhost");
        broker.setUseJmx(false);
        broker.setDeleteAllMessagesOnStartup(true);
        broker.addConnector("vm://localhost");
        broker.start();
        broker.waitUntilStarted();
        return broker;
    }
}

