/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker;

import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.JmsMultipleClientsTestSupport;
import org.apache.activemq.command.ActiveMQDestination;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.BlockJUnit4ClassRunner;

@RunWith(value=BlockJUnit4ClassRunner.class)
public class QueueSubscriptionTest
extends JmsMultipleClientsTestSupport {
    protected int messageCount = 1000;
    protected int prefetchCount = 10;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.durable = false;
        this.topic = false;
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test(timeout=60000L)
    public void testManyProducersOneConsumer() throws Exception {
        this.consumerCount = 1;
        this.producerCount = 10;
        this.messageCount = 100;
        this.messageSize = 1;
        this.prefetchCount = 10;
        this.doMultipleClientsTest();
        this.assertTotalMessagesReceived(this.messageCount * this.producerCount);
        this.assertDestinationMemoryUsageGoesToZero();
    }

    @Test(timeout=60000L)
    public void testOneProducerTwoConsumersSmallMessagesOnePrefetch() throws Exception {
        this.consumerCount = 2;
        this.producerCount = 1;
        this.messageCount = 1000;
        this.messageSize = 1024;
        this.configurePrefetchOfOne();
        this.doMultipleClientsTest();
        this.assertTotalMessagesReceived(this.messageCount * this.producerCount);
        this.assertDestinationMemoryUsageGoesToZero();
    }

    @Test(timeout=60000L)
    public void testOneProducerTwoConsumersSmallMessagesLargePrefetch() throws Exception {
        this.consumerCount = 2;
        this.producerCount = 1;
        this.messageCount = 1000;
        this.prefetchCount = this.messageCount * 2;
        this.messageSize = 1024;
        this.doMultipleClientsTest();
        this.assertTotalMessagesReceived(this.messageCount * this.producerCount);
        this.assertDestinationMemoryUsageGoesToZero();
    }

    @Test(timeout=120000L)
    public void testOneProducerTwoConsumersLargeMessagesOnePrefetch() throws Exception {
        this.consumerCount = 2;
        this.producerCount = 1;
        this.messageCount = 10;
        this.messageSize = 0x100000;
        this.configurePrefetchOfOne();
        this.doMultipleClientsTest();
        this.assertTotalMessagesReceived(this.messageCount * this.producerCount);
        this.assertDestinationMemoryUsageGoesToZero();
    }

    @Test(timeout=60000L)
    public void testOneProducerTwoConsumersLargeMessagesLargePrefetch() throws Exception {
        this.consumerCount = 2;
        this.producerCount = 1;
        this.messageCount = 10;
        this.prefetchCount = this.messageCount * 2;
        this.messageSize = 0x100000;
        this.doMultipleClientsTest();
        this.assertTotalMessagesReceived(this.messageCount * this.producerCount);
        this.assertDestinationMemoryUsageGoesToZero();
    }

    @Test(timeout=60000L)
    public void testOneProducerManyConsumersFewMessages() throws Exception {
        this.consumerCount = 50;
        this.producerCount = 1;
        this.messageCount = 10;
        this.messageSize = 1;
        this.prefetchCount = 10;
        this.doMultipleClientsTest();
        this.assertTotalMessagesReceived(this.messageCount * this.producerCount);
        this.assertDestinationMemoryUsageGoesToZero();
    }

    @Test(timeout=60000L)
    public void testOneProducerManyConsumersManyMessages() throws Exception {
        this.consumerCount = 50;
        this.producerCount = 1;
        this.messageCount = 1000;
        this.messageSize = 1;
        this.prefetchCount = this.messageCount / this.consumerCount;
        this.allMessagesList.setMaximumDuration(this.allMessagesList.getMaximumDuration() * 20L);
        this.doMultipleClientsTest();
        this.assertTotalMessagesReceived(this.messageCount * this.producerCount);
        this.assertDestinationMemoryUsageGoesToZero();
    }

    @Test(timeout=120000L)
    public void testManyProducersManyConsumers() throws Exception {
        this.consumerCount = 200;
        this.producerCount = 50;
        this.messageCount = 100;
        this.messageSize = 1;
        this.prefetchCount = 100;
        this.allMessagesList.setMaximumDuration(this.allMessagesList.getMaximumDuration() * 20L);
        this.doMultipleClientsTest();
        this.assertTotalMessagesReceived(this.messageCount * this.producerCount);
        this.assertDestinationMemoryUsageGoesToZero();
    }

    protected void configurePrefetchOfOne() {
        this.prefetchCount = 1;
        this.allMessagesList.setMaximumDuration(this.allMessagesList.getMaximumDuration() * 20L);
    }

    public void doMultipleClientsTest() throws Exception {
        ActiveMQDestination dest = this.createDestination();
        ActiveMQConnectionFactory consumerFactory = (ActiveMQConnectionFactory)this.createConnectionFactory();
        consumerFactory.getPrefetchPolicy().setAll(this.prefetchCount);
        this.startConsumers((ConnectionFactory)consumerFactory, (Destination)dest);
        this.startProducers((Destination)dest, this.messageCount);
        int totalMessageCount = this.messageCount * this.producerCount;
        if (dest.isTopic()) {
            totalMessageCount *= this.consumerCount;
        }
        this.waitForAllMessagesToBeReceived(totalMessageCount);
    }
}

