/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.ServerSocket;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQTopicSubscriber;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.ManagementContext;
import org.apache.activemq.command.ActiveMQTopic;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AMQ3678Test
implements MessageListener {
    public int deliveryMode = 1;
    private BrokerService broker;
    AtomicInteger messagesSent = new AtomicInteger(0);
    AtomicInteger messagesReceived = new AtomicInteger(0);
    ActiveMQTopic destination = new ActiveMQTopic("XYZ");
    int port;
    int jmxport;
    final CountDownLatch latch = new CountDownLatch(2);

    public static void main(String[] args) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int findFreePort() throws IOException {
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(0);
            int n = socket.getLocalPort();
            return n;
        }
        finally {
            if (socket != null) {
                socket.close();
            }
        }
    }

    @Test
    public void countConsumers() throws JMSException {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("tcp://localhost:" + this.port);
        factory.setAlwaysSyncSend(true);
        factory.setDispatchAsync(false);
        Connection producerConnection = factory.createConnection();
        producerConnection.start();
        Connection consumerConnection = factory.createConnection();
        consumerConnection.setClientID("subscriber1");
        Session consumerMQSession = consumerConnection.createSession(false, 2);
        ActiveMQTopicSubscriber activeConsumer = (ActiveMQTopicSubscriber)consumerMQSession.createDurableSubscriber((Topic)this.destination, "myTopic?consumer.prefetchSize=1");
        activeConsumer.setMessageListener((MessageListener)this);
        consumerConnection.start();
        final Session producerSession = producerConnection.createSession(false, 1);
        final MessageProducer producer = producerSession.createProducer((Destination)this.destination);
        producer.setDeliveryMode(this.deliveryMode);
        Thread t = new Thread(new Runnable(){
            private boolean done = false;

            @Override
            public void run() {
                while (!this.done) {
                    if (AMQ3678Test.this.messagesSent.get() == 50) {
                        try {
                            AMQ3678Test.this.broker.getAdminView().removeTopic(AMQ3678Test.this.destination.getTopicName());
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                            System.err.flush();
                            Assert.fail((String)("Unable to remove destination:" + AMQ3678Test.this.destination.getPhysicalName()));
                        }
                    }
                    try {
                        producer.send((Message)producerSession.createTextMessage());
                        int val = AMQ3678Test.this.messagesSent.incrementAndGet();
                        System.out.println("sent message (" + val + ")");
                        System.out.flush();
                        if (val != 100) continue;
                        this.done = true;
                        AMQ3678Test.this.latch.countDown();
                        producer.close();
                        producerSession.close();
                    }
                    catch (JMSException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        t.start();
        try {
            if (!this.latch.await(10L, TimeUnit.SECONDS)) {
                Assert.fail((String)"did not receive all the messages");
            }
        }
        catch (InterruptedException e) {
            Assert.fail((String)"did not receive all the messages, exception waiting for latch");
            e.printStackTrace();
        }
    }

    @Before
    public void setUp() throws Exception {
        try {
            this.port = AMQ3678Test.findFreePort();
            this.jmxport = AMQ3678Test.findFreePort();
        }
        catch (Exception e) {
            Assert.fail((String)"Unable to obtain a free port on which to start the broker");
        }
        System.out.println("Starting broker");
        System.out.flush();
        this.broker = new BrokerService();
        this.broker.setPersistent(false);
        ManagementContext ctx = new ManagementContext(ManagementFactory.getPlatformMBeanServer());
        ctx.setConnectorPort(this.jmxport);
        this.broker.setManagementContext(ctx);
        this.broker.setUseJmx(true);
        this.broker.addConnector("tcp://localhost:" + this.port).setName("Default");
        this.broker.start();
        System.out.println("End of Broker Setup");
        System.out.flush();
    }

    @After
    public void tearDown() throws Exception {
        this.broker.stop();
    }

    public void onMessage(Message message) {
        try {
            message.acknowledge();
            int val = this.messagesReceived.incrementAndGet();
            System.out.println("received message (" + val + ")");
            System.out.flush();
            if (this.messagesReceived.get() == 100) {
                this.latch.countDown();
            }
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
    }
}

