/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ4554Test
extends TestCase {
    private final Logger LOG = LoggerFactory.getLogger(AMQ4554Test.class);
    private String connectionURI;
    private BrokerService broker;

    protected void setUp() throws Exception {
        super.setUp();
        this.broker = new BrokerService();
        this.connectionURI = this.broker.addConnector("tcp://0.0.0.0:0?maximumConnections=1").getPublishableConnectString();
        this.broker.setPersistent(false);
        this.broker.start();
    }

    protected void tearDown() throws Exception {
        this.broker.stop();
        super.tearDown();
    }

    public AMQ4554Test(String testName) {
        super(testName);
    }

    public static Test suite() {
        return new TestSuite(AMQ4554Test.class);
    }

    public void testMSXProducerTXID() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.connectionURI);
        Connection connection = factory.createConnection();
        connection.start();
        Session producerSession = connection.createSession(true, 0);
        MessageProducer producer = producerSession.createProducer((Destination)producerSession.createQueue("myQueue"));
        TextMessage producerMessage = producerSession.createTextMessage("Test Message");
        producer.send((Message)producerMessage);
        producer.close();
        producerSession.commit();
        producerSession.close();
        Session consumerSession = connection.createSession(true, 0);
        MessageConsumer consumer = consumerSession.createConsumer((Destination)consumerSession.createQueue("myQueue"));
        Message consumerMessage = consumer.receive(1000L);
        try {
            String txId = consumerMessage.getStringProperty("JMSXProducerTXID");
            AMQ4554Test.assertNotNull((Object)txId);
        }
        catch (Exception e) {
            this.LOG.info("Caught Exception that was not expected:", (Throwable)e);
            AMQ4554Test.fail((String)"Should not throw");
        }
        consumer.close();
        consumerSession.commit();
        consumerSession.close();
        connection.close();
    }
}

