/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import javax.jms.JMSException;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;

public class ConnectionCleanupTest
extends TestCase {
    private ActiveMQConnection connection;

    protected void setUp() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://localhost?broker.persistent=false");
        this.connection = (ActiveMQConnection)factory.createConnection();
    }

    protected void tearDown() throws Exception {
        this.connection.close();
    }

    public void testChangeClientID() throws JMSException {
        this.connection.setClientID("test");
        this.connection.createSession(false, 1);
        try {
            this.connection.setClientID("test");
            ConnectionCleanupTest.fail((String)"Should have received JMSException");
        }
        catch (JMSException e) {
            // empty catch block
        }
        this.connection.doCleanup(true);
        this.connection.setClientID("test");
        this.connection.createSession(false, 1);
        try {
            this.connection.setClientID("test");
            ConnectionCleanupTest.fail((String)"Should have received JMSException");
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    public void testChangeClientIDDenied() throws JMSException {
        this.connection.setClientID("test");
        this.connection.createSession(false, 1);
        try {
            this.connection.setClientID("test");
            ConnectionCleanupTest.fail((String)"Should have received JMSException");
        }
        catch (JMSException e) {
            // empty catch block
        }
        this.connection.cleanup();
        try {
            this.connection.setClientID("test");
            ConnectionCleanupTest.fail((String)"Should have received JMSException");
        }
        catch (JMSException e) {
            // empty catch block
        }
        this.connection.createSession(false, 1);
        try {
            this.connection.setClientID("test");
            ConnectionCleanupTest.fail((String)"Should have received JMSException");
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }
}

