/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.jmx;

import java.io.File;
import java.util.NoSuchElementException;
import java.util.concurrent.CountDownLatch;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.BrokerView;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBStore;
import org.apache.activemq.util.Wait;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerViewSlowStoreStartupTest {
    private static final Logger LOG = LoggerFactory.getLogger(BrokerViewSlowStoreStartupTest.class);
    private final CountDownLatch holdStoreStart = new CountDownLatch(1);
    private final String brokerName = "brokerViewTest";
    private BrokerService broker;
    private Thread startThread;

    private BrokerService createBroker() throws Exception {
        BrokerService broker = new BrokerService();
        broker.setBrokerName("brokerViewTest");
        KahaDBStore kaha = new KahaDBStore(){

            public void start() throws Exception {
                LOG.info("Test KahaDB class is waiting for signal to complete its start()");
                BrokerViewSlowStoreStartupTest.this.holdStoreStart.await();
                super.start();
                LOG.info("Test KahaDB class is completed its start()");
            }
        };
        kaha.setDirectory(new File("target/activemq-data/kahadb"));
        kaha.deleteAllMessages();
        broker.setPersistenceAdapter((PersistenceAdapter)kaha);
        broker.setUseJmx(true);
        return broker;
    }

    @Before
    public void setUp() throws Exception {
        this.broker = this.createBroker();
        this.startThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    BrokerViewSlowStoreStartupTest.this.broker.start();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.startThread.start();
    }

    @After
    public void tearDown() throws Exception {
        this.holdStoreStart.countDown();
        this.startThread.join();
        if (this.broker != null) {
            this.broker.stop();
            this.broker.waitUntilStopped();
        }
    }

    @Test(timeout=120000L)
    public void testBrokerViewOnSlowStoreStart() throws Exception {
        Assert.assertTrue((boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return BrokerViewSlowStoreStartupTest.this.broker.getAdminView() != null;
            }
        }));
        final BrokerView view = this.broker.getAdminView();
        try {
            view.getBrokerName();
            Assert.fail((String)"Should have thrown an IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            view.getBrokerId();
            Assert.fail((String)"Should have thrown an IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            view.getTotalEnqueueCount();
            Assert.fail((String)"Should have thrown an IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            view.getTotalDequeueCount();
            Assert.fail((String)"Should have thrown an IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            view.getTotalConsumerCount();
            Assert.fail((String)"Should have thrown an IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            view.getTotalProducerCount();
            Assert.fail((String)"Should have thrown an IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            view.getTotalMessageCount();
            Assert.fail((String)"Should have thrown an IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            view.getTotalMessagesCached();
            Assert.fail((String)"Should have thrown an IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            view.resetStatistics();
            Assert.fail((String)"Should have thrown an IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            view.enableStatistics();
            Assert.fail((String)"Should have thrown an IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            view.disableStatistics();
            Assert.fail((String)"Should have thrown an IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            view.isStatisticsEnabled();
            Assert.fail((String)"Should have thrown an IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            view.getTopics();
            Assert.fail((String)"Should have thrown an IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            view.getQueues();
            Assert.fail((String)"Should have thrown an IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            view.getTemporaryTopics();
            Assert.fail((String)"Should have thrown an IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            view.getTemporaryQueues();
            Assert.fail((String)"Should have thrown an IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            view.getTopicSubscribers();
            Assert.fail((String)"Should have thrown an IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            view.getDurableTopicSubscribers();
            Assert.fail((String)"Should have thrown an IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            view.getQueueSubscribers();
            Assert.fail((String)"Should have thrown an IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            view.getTemporaryTopicSubscribers();
            Assert.fail((String)"Should have thrown an IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            view.getTemporaryQueueSubscribers();
            Assert.fail((String)"Should have thrown an IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            view.getInactiveDurableTopicSubscribers();
            Assert.fail((String)"Should have thrown an IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            view.getTopicProducers();
            Assert.fail((String)"Should have thrown an IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            view.getQueueProducers();
            Assert.fail((String)"Should have thrown an IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            view.getTemporaryTopicProducers();
            Assert.fail((String)"Should have thrown an IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            view.getTemporaryQueueProducers();
            Assert.fail((String)"Should have thrown an IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            view.getDynamicDestinationProducers();
            Assert.fail((String)"Should have thrown an IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            view.removeConnector("tcp");
            Assert.fail((String)"Should have thrown an NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        try {
            view.removeNetworkConnector("tcp");
            Assert.fail((String)"Should have thrown an NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        try {
            view.addTopic("TEST");
            Assert.fail((String)"Should have thrown an IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            view.addQueue("TEST");
            Assert.fail((String)"Should have thrown an IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            view.removeTopic("TEST");
            Assert.fail((String)"Should have thrown an IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            view.removeQueue("TEST");
            Assert.fail((String)"Should have thrown an IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            view.createDurableSubscriber("1", "2", "3", "4");
            Assert.fail((String)"Should have thrown an IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            view.destroyDurableSubscriber("1", "2");
            Assert.fail((String)"Should have thrown an IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        this.holdStoreStart.countDown();
        this.startThread.join();
        Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return view.getBroker() != null;
            }
        });
        Assert.assertNotNull((Object)view.getBroker());
        try {
            view.getBrokerName();
        }
        catch (Exception e) {
            Assert.fail((String)("caught an exception getting the Broker property: " + e.getClass().getName()));
        }
        try {
            view.getBrokerId();
        }
        catch (IllegalStateException e) {
            Assert.fail((String)("caught an exception getting the Broker property: " + e.getClass().getName()));
        }
        try {
            view.getTotalEnqueueCount();
        }
        catch (IllegalStateException e) {
            Assert.fail((String)("caught an exception getting the Broker property: " + e.getClass().getName()));
        }
    }
}

