/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.network.DemandForwardingBridgeSupport;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.util.Wait;
import org.junit.Assert;
import org.junit.Test;

public class NetworkLoopBackTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoopbackOnDifferentUrlScheme() throws Exception {
        BrokerService brokerServce = new BrokerService();
        brokerServce.setPersistent(false);
        TransportConnector transportConnector = brokerServce.addConnector("nio://0.0.0.0:0");
        final NetworkConnector networkConnector = brokerServce.addNetworkConnector("static:(tcp://" + transportConnector.getConnectUri().getHost() + ":" + transportConnector.getConnectUri().getPort() + ")");
        brokerServce.start();
        brokerServce.waitUntilStarted();
        try {
            Wait.waitFor((Wait.Condition)new Wait.Condition(){

                public boolean isSatisified() throws Exception {
                    return 1 == networkConnector.bridges.size();
                }
            });
            final DemandForwardingBridgeSupport loopbackBridge = (DemandForwardingBridgeSupport)networkConnector.bridges.elements().nextElement();
            Assert.assertTrue((String)"nc started", (boolean)networkConnector.isStarted());
            Assert.assertTrue((String)"It should get disposed", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

                public boolean isSatisified() throws Exception {
                    return loopbackBridge.getRemoteBroker().isDisposed();
                }
            }));
            Assert.assertEquals((String)"No peer brokers", (long)0L, (long)brokerServce.getBroker().getPeerBrokerInfos().length);
        }
        finally {
            brokerServce.stop();
        }
    }
}

