/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.jdbc;

import java.io.File;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.XASession;
import javax.sql.DataSource;
import javax.transaction.xa.Xid;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQXAConnection;
import org.apache.activemq.ActiveMQXAConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.apache.activemq.util.IOHelper;
import org.apache.activemq.util.TestUtils;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.derby.jdbc.EmbeddedDataSource;
import org.apache.derby.jdbc.EmbeddedDriver;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class JDBCCleanupLimitedPoolTest {
    BrokerService broker;
    JDBCPersistenceAdapter jdbcPersistenceAdapter;
    BasicDataSource pool;
    EmbeddedDataSource derby;

    @Before
    public void setUp() throws Exception {
        System.setProperty("derby.system.home", new File(IOHelper.getDefaultDataDirectory()).getCanonicalPath());
        this.derby = new EmbeddedDataSource();
        this.derby.setDatabaseName("derbyDb");
        this.derby.setCreateDatabase("create");
        this.broker = this.createBroker();
        this.broker.start();
        this.broker.waitUntilStarted();
    }

    @After
    public void tearDown() throws Exception {
        this.broker.stop();
        this.pool.close();
    }

    protected BrokerService createBroker() throws Exception {
        this.broker = new BrokerService();
        this.broker.setUseJmx(false);
        this.jdbcPersistenceAdapter = new JDBCPersistenceAdapter();
        this.jdbcPersistenceAdapter.deleteAllMessages();
        this.jdbcPersistenceAdapter.setCleanupPeriod(0);
        this.jdbcPersistenceAdapter.setUseLock(false);
        this.pool = new BasicDataSource();
        this.pool.setDriverClassName(EmbeddedDriver.class.getCanonicalName());
        this.pool.setUrl("jdbc:derby:derbyDb;create=false");
        this.pool.setUsername("uid");
        this.pool.setPassword("pwd");
        this.pool.setMaxActive(2);
        this.jdbcPersistenceAdapter.setDataSource((DataSource)this.pool);
        this.broker.setPersistenceAdapter((PersistenceAdapter)this.jdbcPersistenceAdapter);
        this.broker.addConnector("tcp://0.0.0.0:0");
        return this.broker;
    }

    @Test
    public void testNoDeadlockOnXaPoolExhaustion() throws Exception {
        final CountDownLatch done = new CountDownLatch(1);
        final CountDownLatch doneCommit = new CountDownLatch(2000);
        final ActiveMQXAConnectionFactory factory = new ActiveMQXAConnectionFactory(this.broker.getTransportConnectorByScheme("tcp").getPublishableConnectString());
        ExecutorService executorService = Executors.newCachedThreadPool();
        for (int i = 0; i < 3; ++i) {
            executorService.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        ActiveMQXAConnection conn = (ActiveMQXAConnection)factory.createXAConnection();
                        conn.start();
                        XASession sess = conn.createXASession();
                        while (done.getCount() > 0L && doneCommit.getCount() > 0L) {
                            Xid xid = TestUtils.createXid();
                            sess.getXAResource().start(xid, 0);
                            MessageProducer producer = sess.createProducer((Destination)sess.createQueue("test"));
                            producer.send((Message)sess.createTextMessage("test"));
                            sess.getXAResource().end(xid, 0x4000000);
                            sess.getXAResource().prepare(xid);
                            sess.getXAResource().commit(xid, false);
                            doneCommit.countDown();
                        }
                        conn.close();
                    }
                    catch (Exception ignored) {
                        ignored.printStackTrace();
                    }
                }
            });
        }
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    while (!done.await(10L, TimeUnit.MILLISECONDS) && doneCommit.getCount() > 0L) {
                        JDBCCleanupLimitedPoolTest.this.jdbcPersistenceAdapter.cleanup();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        executorService.shutdown();
        boolean allComplete = executorService.awaitTermination(20L, TimeUnit.SECONDS);
        done.countDown();
        TestCase.assertTrue((String)"all complete", (boolean)allComplete);
        executorService.shutdownNow();
        TestCase.assertTrue((String)"xa tx done", (boolean)doneCommit.await(10L, TimeUnit.SECONDS));
    }
}

