/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadb;

import java.io.File;
import java.io.RandomAccessFile;
import java.util.concurrent.atomic.AtomicLong;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQQueue;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoSpaceIOTest {
    private static final Logger LOG = LoggerFactory.getLogger(NoSpaceIOTest.class);

    public static void main(String[] args) throws Exception {
        new NoSpaceIOTest().testRunOutOfSpace();
    }

    @Ignore(value="needs small volume, like usb key")
    @Test
    public void testRunOutOfSpace() throws Exception {
        BrokerService broker = new BrokerService();
        File dataDir = new File("/Volumes/NO NAME/");
        File useUpSpace = new File(dataDir, "bigFile");
        if (!useUpSpace.exists()) {
            LOG.info("using up some space...");
            RandomAccessFile filler = new RandomAccessFile(useUpSpace, "rw");
            filler.setLength(1270874112L);
            filler.close();
            File toDelete = new File(dataDir, "toDelete");
            filler = new RandomAccessFile(toDelete, "rw");
            filler.setLength(0x14000000L);
            filler.close();
        }
        broker.setDataDirectoryFile(dataDir);
        broker.start();
        AtomicLong consumed = new AtomicLong(0L);
        this.consume(consumed);
        LOG.info("consumed: " + consumed);
        broker.getPersistenceAdapter().checkpoint(true);
        AtomicLong sent = new AtomicLong(0L);
        try {
            this.produce(sent, 200L);
        }
        catch (Exception expected) {
            LOG.info("got ex, sent: " + sent);
        }
        LOG.info("sent: " + sent);
        System.out.println("Remove toDelete file and press any key to continue");
        int read = System.in.read();
        System.err.println("read:" + read);
        LOG.info("Trying to send again: " + sent);
        try {
            this.produce(sent, 200L);
        }
        catch (Exception expected) {
            LOG.info("got ex, sent: " + sent);
        }
        LOG.info("sent: " + sent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consume(AtomicLong consumed) throws JMSException {
        Connection c = new ActiveMQConnectionFactory("vm://localhost").createConnection();
        try {
            c.start();
            Session s = c.createSession(false, 1);
            MessageConsumer consumer = s.createConsumer((Destination)new ActiveMQQueue("t"));
            while (consumer.receive(2000L) != null) {
                consumed.incrementAndGet();
            }
        }
        finally {
            c.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void produce(AtomicLong sent, long toSend) throws JMSException {
        Connection c = new ActiveMQConnectionFactory("vm://localhost").createConnection();
        try {
            c.start();
            Session s = c.createSession(false, 1);
            MessageProducer producer = s.createProducer((Destination)new ActiveMQQueue("t"));
            TextMessage m = s.createTextMessage();
            m.setText(String.valueOf(new char[0x100000]));
            int i = 0;
            while ((long)i < toSend) {
                producer.send((Message)m);
                sent.incrementAndGet();
                ++i;
            }
        }
        finally {
            c.close();
        }
    }
}

