/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.net.URI;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.management.ObjectName;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.advisory.DestinationSource;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.DestinationViewMBean;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQTopic;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RemoveDestinationTest {
    private static final String VM_BROKER_URL = "vm://localhost?create=false";
    private static final String BROKER_URL = "broker:vm://localhost?broker.persistent=false&broker.useJmx=true";
    BrokerService broker;

    @Before
    public void setUp() throws Exception {
        this.broker = BrokerFactory.createBroker((URI)new URI(BROKER_URL));
        this.broker.start();
        this.broker.waitUntilStarted();
    }

    @After
    public void tearDown() throws Exception {
        this.broker.stop();
        this.broker.waitUntilStopped();
        this.broker = null;
    }

    private Connection createConnection(boolean start) throws JMSException {
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory(VM_BROKER_URL);
        Connection conn = cf.createConnection();
        if (start) {
            conn.start();
        }
        return conn;
    }

    @Test
    public void testRemoveDestinationWithoutSubscriber() throws Exception {
        ActiveMQConnection amqConnection = (ActiveMQConnection)this.createConnection(true);
        DestinationSource destinationSource = amqConnection.getDestinationSource();
        Session session = amqConnection.createSession(false, 1);
        Topic topic = session.createTopic("TEST.FOO");
        MessageProducer producer = session.createProducer((Destination)topic);
        MessageConsumer consumer = session.createConsumer((Destination)topic);
        TextMessage msg = session.createTextMessage("Hellow World");
        producer.send((Message)msg);
        Assert.assertNotNull((Object)consumer.receive(5000L));
        Thread.sleep(1000L);
        ActiveMQTopic amqTopic = (ActiveMQTopic)topic;
        Assert.assertTrue((boolean)destinationSource.getTopics().contains(amqTopic));
        consumer.close();
        producer.close();
        session.close();
        Thread.sleep(3000L);
        amqConnection.destroyDestination((ActiveMQDestination)topic);
        Thread.sleep(3000L);
        Assert.assertFalse((boolean)destinationSource.getTopics().contains(amqTopic));
    }

    @Test
    public void testRemoveDestinationWithSubscriber() throws Exception {
        ActiveMQConnection amqConnection = (ActiveMQConnection)this.createConnection(true);
        DestinationSource destinationSource = amqConnection.getDestinationSource();
        Session session = amqConnection.createSession(false, 1);
        Topic topic = session.createTopic("TEST.FOO");
        MessageProducer producer = session.createProducer((Destination)topic);
        MessageConsumer consumer = session.createConsumer((Destination)topic);
        TextMessage msg = session.createTextMessage("Hellow World");
        producer.send((Message)msg);
        Assert.assertNotNull((Object)consumer.receive(5000L));
        Thread.sleep(1000L);
        ActiveMQTopic amqTopic = (ActiveMQTopic)topic;
        Assert.assertTrue((boolean)this.destinationPresentInAdminView(this.broker, amqTopic));
        Assert.assertTrue((boolean)destinationSource.getTopics().contains(amqTopic));
        try {
            amqConnection.destroyDestination((ActiveMQDestination)topic);
            Assert.fail((String)"expect exception on destroy if comsumer present");
        }
        catch (JMSException expected) {
            Assert.assertTrue((expected.getMessage().indexOf(amqTopic.getTopicName()) != -1 ? 1 : 0) != 0);
        }
        Thread.sleep(3000L);
        Assert.assertTrue((boolean)destinationSource.getTopics().contains(amqTopic));
        Assert.assertTrue((boolean)this.destinationPresentInAdminView(this.broker, amqTopic));
        consumer.close();
        producer.close();
        session.close();
        Thread.sleep(3000L);
        amqConnection.destroyDestination((ActiveMQDestination)amqTopic);
        Thread.sleep(3000L);
        Assert.assertFalse((boolean)destinationSource.getTopics().contains(amqTopic));
        Assert.assertFalse((boolean)this.destinationPresentInAdminView(this.broker, amqTopic));
    }

    private boolean destinationPresentInAdminView(BrokerService broker2, ActiveMQTopic amqTopic) throws Exception {
        boolean found = false;
        for (ObjectName name : this.broker.getAdminView().getTopics()) {
            DestinationViewMBean proxy = (DestinationViewMBean)this.broker.getManagementContext().newProxyInstance(name, DestinationViewMBean.class, true);
            if (!proxy.getName().equals(amqTopic.getPhysicalName())) continue;
            found = true;
            break;
        }
        return found;
    }
}

