/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.RedeliveryPolicy;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBStore;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AMQ2982Test {
    private static final int MAX_MESSAGES = 500;
    private static final String QUEUE_NAME = "test.queue";
    private BrokerService broker;
    private final CountDownLatch messageCountDown = new CountDownLatch(500);
    private CleanableKahaDBStore kahaDB;

    @Before
    public void setup() throws Exception {
        this.broker = new BrokerService();
        this.broker.setDeleteAllMessagesOnStartup(true);
        this.broker.setPersistent(true);
        this.kahaDB = new CleanableKahaDBStore();
        this.kahaDB.setJournalMaxFileLength(262144);
        this.broker.setPersistenceAdapter((PersistenceAdapter)this.kahaDB);
        this.broker.start();
        this.broker.waitUntilStarted();
    }

    private Connection registerDLQMessageListener() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://localhost");
        Connection connection = factory.createConnection();
        connection.start();
        Session session = connection.createSession(false, 1);
        MessageConsumer consumer = session.createConsumer((Destination)session.createQueue("ActiveMQ.DLQ"));
        consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                AMQ2982Test.this.messageCountDown.countDown();
            }
        });
        return connection;
    }

    private void sendMessages() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://localhost");
        Connection connection = factory.createConnection();
        connection.start();
        Session session = connection.createSession(false, 1);
        MessageProducer producer = session.createProducer((Destination)session.createQueue(QUEUE_NAME));
        producer.setDeliveryMode(2);
        for (int i = 0; i < 500; ++i) {
            BytesMessage message = session.createBytesMessage();
            message.writeBytes(new byte[1000]);
            producer.send((Message)message);
        }
        producer.close();
        session.close();
        connection.close();
    }

    @Test
    public void testNoStickyKahaDbLogFilesOnLocalTransactionRollback() throws Exception {
        Connection dlqConnection = this.registerDLQMessageListener();
        ConsumerThread thread = new ConsumerThread();
        thread.start();
        this.sendMessages();
        thread.join(60000L);
        Assert.assertFalse((boolean)thread.isAlive());
        dlqConnection.close();
        this.kahaDB.forceCleanup();
        Assert.assertEquals((String)"only one active KahaDB log file after cleanup is expected", (long)1L, (long)this.kahaDB.getFileMapSize());
    }

    @After
    public void tearDown() throws Exception {
        this.broker.stop();
    }

    class ConsumerThread
    extends Thread {
        ConsumerThread() {
        }

        @Override
        public void run() {
            try {
                ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://localhost");
                RedeliveryPolicy policy = new RedeliveryPolicy();
                policy.setMaximumRedeliveries(0);
                policy.setInitialRedeliveryDelay(100L);
                policy.setUseExponentialBackOff(false);
                factory.setRedeliveryPolicy(policy);
                Connection connection = factory.createConnection();
                connection.start();
                Session session = connection.createSession(true, 0);
                MessageConsumer consumer = session.createConsumer((Destination)session.createQueue(AMQ2982Test.QUEUE_NAME));
                do {
                    Message message;
                    if ((message = consumer.receive(300L)) == null) continue;
                    session.rollback();
                } while (AMQ2982Test.this.messageCountDown.getCount() != 0L);
                consumer.close();
                session.close();
                connection.close();
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
            }
        }
    }

    private static class CleanableKahaDBStore
    extends KahaDBStore {
        private CleanableKahaDBStore() {
        }

        public void forceCleanup() throws IOException {
            this.checkpointCleanup(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getFileMapSize() throws IOException {
            this.indexLock.readLock().lock();
            try {
                int n = this.getJournal().getFileMap().size();
                return n;
            }
            finally {
                this.indexLock.readLock().unlock();
            }
        }
    }
}

