/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.io.File;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.region.policy.DeadLetterStrategy;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.broker.region.policy.SharedDeadLetterStrategy;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.store.kahadb.plist.PListStoreImpl;
import org.apache.activemq.util.Wait;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TempStoreDataCleanupTest {
    private static final Logger LOG = LoggerFactory.getLogger(TempStoreDataCleanupTest.class);
    private static final String QUEUE_NAME = TempStoreDataCleanupTest.class.getName() + "Queue";
    private final String str = new String("QAa0bcLdUK2eHfJgTP8XhiFj61DOklNm9nBoI5pGqYVrs3CtSuMZvwWx4yE7zR");
    private BrokerService broker;
    private String connectionUri;
    private ExecutorService pool;
    private String queueName;
    private Random r = new Random();

    @Before
    public void setUp() throws Exception {
        this.broker = new BrokerService();
        this.broker.setDataDirectory("target" + File.separator + "activemq-data");
        this.broker.setPersistent(true);
        this.broker.setUseJmx(true);
        this.broker.setDedicatedTaskRunner(false);
        this.broker.setAdvisorySupport(false);
        this.broker.setDeleteAllMessagesOnStartup(true);
        SharedDeadLetterStrategy strategy = new SharedDeadLetterStrategy();
        strategy.setProcessExpired(false);
        strategy.setProcessNonPersistent(false);
        PolicyEntry defaultPolicy = new PolicyEntry();
        defaultPolicy.setQueue(">");
        defaultPolicy.setOptimizedDispatch(true);
        defaultPolicy.setDeadLetterStrategy((DeadLetterStrategy)strategy);
        defaultPolicy.setMemoryLimit(9000000L);
        PolicyMap policyMap = new PolicyMap();
        policyMap.setDefaultEntry(defaultPolicy);
        this.broker.setDestinationPolicy(policyMap);
        this.broker.getSystemUsage().getMemoryUsage().setLimit(300000000L);
        this.broker.addConnector("tcp://localhost:0").setName("Default");
        this.broker.start();
        this.broker.waitUntilStarted();
        this.connectionUri = ((TransportConnector)this.broker.getTransportConnectors().get(0)).getPublishableConnectString();
        this.pool = Executors.newFixedThreadPool(10);
    }

    @After
    public void tearDown() throws Exception {
        if (this.broker != null) {
            this.broker.stop();
            this.broker.waitUntilStopped();
        }
        if (this.pool != null) {
            this.pool.shutdown();
        }
    }

    @Test
    public void testIt() throws Exception {
        int startPercentage = this.broker.getAdminView().getMemoryPercentUsage();
        LOG.info("MemoryUsage at test start = " + startPercentage);
        for (int i = 0; i < 2; ++i) {
            LOG.info("Started the test iteration: " + i + " using queueName = " + this.queueName);
            this.queueName = QUEUE_NAME + i;
            final CountDownLatch latch = new CountDownLatch(11);
            this.pool.execute(new Runnable(){

                @Override
                public void run() {
                    TempStoreDataCleanupTest.this.receiveAndDiscard100messages(latch);
                }
            });
            for (int j = 0; j < 10; ++j) {
                this.pool.execute(new Runnable(){

                    @Override
                    public void run() {
                        TempStoreDataCleanupTest.this.send10000messages(latch);
                    }
                });
            }
            LOG.info("Waiting on the send / receive latch");
            latch.await(5L, TimeUnit.MINUTES);
            LOG.info("Resumed");
            this.destroyQueue();
            TimeUnit.SECONDS.sleep(2L);
        }
        LOG.info("MemoryUsage before awaiting temp store cleanup = " + this.broker.getAdminView().getMemoryPercentUsage());
        final PListStoreImpl pa = (PListStoreImpl)this.broker.getTempDataStore();
        Assert.assertTrue((String)("only one journal file should be left: " + pa.getJournal().getFileMap().size()), (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return pa.getJournal().getFileMap().size() == 1;
            }
        }, (long)TimeUnit.MINUTES.toMillis(3L)));
        int endPercentage = this.broker.getAdminView().getMemoryPercentUsage();
        LOG.info("MemoryUseage at test end = " + endPercentage);
        Assert.assertEquals((long)startPercentage, (long)endPercentage);
    }

    public void destroyQueue() {
        try {
            Broker broker = this.broker.getBroker();
            if (!broker.isStopped()) {
                LOG.info("Removing: " + this.queueName);
                broker.removeDestination(this.broker.getAdminConnectionContext(), (ActiveMQDestination)new ActiveMQQueue(this.queueName), 10L);
            }
        }
        catch (Exception e) {
            LOG.warn("Got an error while removing the test queue", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send10000messages(CountDownLatch latch) {
        ActiveMQConnection activeMQConnection = null;
        try {
            activeMQConnection = this.createConnection(null);
            Session session = activeMQConnection.createSession(false, 1);
            MessageProducer producer = session.createProducer((Destination)session.createQueue(this.queueName));
            producer.setDeliveryMode(1);
            activeMQConnection.start();
            for (int i = 0; i < 10000; ++i) {
                TextMessage textMessage = session.createTextMessage();
                textMessage.setText(this.generateBody(1000));
                textMessage.setJMSDeliveryMode(1);
                producer.send((Message)textMessage);
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            producer.close();
        }
        catch (JMSException e) {
            LOG.warn("Got an error while sending the messages", (Throwable)e);
        }
        finally {
            if (activeMQConnection != null) {
                try {
                    activeMQConnection.close();
                }
                catch (JMSException jMSException) {}
            }
        }
        latch.countDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveAndDiscard100messages(CountDownLatch latch) {
        ActiveMQConnection activeMQConnection = null;
        try {
            activeMQConnection = this.createConnection(null);
            Session session = activeMQConnection.createSession(false, 1);
            MessageConsumer messageConsumer = session.createConsumer((Destination)session.createQueue(this.queueName));
            activeMQConnection.start();
            for (int i = 0; i < 100; ++i) {
                messageConsumer.receive();
            }
            messageConsumer.close();
            LOG.info("Created and disconnected");
        }
        catch (JMSException e) {
            LOG.warn("Got an error while receiving the messages", (Throwable)e);
        }
        finally {
            if (activeMQConnection != null) {
                try {
                    activeMQConnection.close();
                }
                catch (JMSException jMSException) {}
            }
        }
        latch.countDown();
    }

    private ActiveMQConnection createConnection(String id) throws JMSException {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.connectionUri);
        if (id != null) {
            factory.setClientID(id);
        }
        ActiveMQConnection connection = (ActiveMQConnection)factory.createConnection();
        return connection;
    }

    private String generateBody(int length) {
        StringBuilder sb = new StringBuilder();
        int te = 0;
        for (int i = 1; i <= length; ++i) {
            te = this.r.nextInt(62);
            sb.append(this.str.charAt(te));
        }
        return sb.toString();
    }
}

