/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactedStoreUsageSuspendResumeTest {
    private static final Logger LOG = LoggerFactory.getLogger(TransactedStoreUsageSuspendResumeTest.class);
    private static final int MAX_MESSAGES = 10000;
    private static final String QUEUE_NAME = "test.queue";
    private BrokerService broker;
    private final CountDownLatch messagesReceivedCountDown = new CountDownLatch(10000);
    private final CountDownLatch messagesSentCountDown = new CountDownLatch(10000);
    private final CountDownLatch consumerStartLatch = new CountDownLatch(1);

    @Before
    public void setup() throws Exception {
        this.broker = new BrokerService();
        this.broker.setDeleteAllMessagesOnStartup(true);
        this.broker.setPersistent(true);
        KahaDBPersistenceAdapter kahaDB = new KahaDBPersistenceAdapter();
        kahaDB.setJournalMaxFileLength(512000);
        kahaDB.setCleanupInterval(10000L);
        this.broker.setPersistenceAdapter((PersistenceAdapter)kahaDB);
        this.broker.getSystemUsage().getStoreUsage().setLimit(0x700000L);
        this.broker.start();
        this.broker.waitUntilStarted();
    }

    @After
    public void tearDown() throws Exception {
        this.broker.stop();
    }

    @Test
    public void testTransactedStoreUsageSuspendResume() throws Exception {
        ConsumerThread thread = new ConsumerThread();
        thread.start();
        ExecutorService sendExecutor = Executors.newSingleThreadExecutor();
        sendExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    TransactedStoreUsageSuspendResumeTest.this.sendMessages();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        sendExecutor.shutdown();
        sendExecutor.awaitTermination(5L, TimeUnit.MINUTES);
        boolean allMessagesReceived = this.messagesReceivedCountDown.await(120L, TimeUnit.SECONDS);
        Assert.assertTrue((String)("Got all messages: " + this.messagesReceivedCountDown), (boolean)allMessagesReceived);
    }

    private void sendMessages() throws Exception {
        int i;
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://localhost");
        factory.setAlwaysSyncSend(true);
        Connection connection = factory.createConnection();
        connection.start();
        Session session = connection.createSession(true, 0);
        Queue queue = session.createQueue(QUEUE_NAME);
        Queue retainQueue = session.createQueue("test.queue-retain");
        MessageProducer producer = session.createProducer(null);
        producer.setDeliveryMode(2);
        BytesMessage message = session.createBytesMessage();
        message.writeBytes(new byte[10]);
        for (i = 0; i < 4240; ++i) {
            producer.send((Destination)retainQueue, (Message)message);
            session.commit();
        }
        this.consumerStartLatch.countDown();
        for (i = 0; i < 10000; ++i) {
            producer.send((Destination)queue, (Message)message);
            if (i > 0 && i % 20 == 0) {
                session.commit();
            }
            this.messagesSentCountDown.countDown();
            if (i <= 0 || i % 500 != 0) continue;
            LOG.info("Sent : " + i);
        }
        session.commit();
        producer.close();
        session.close();
        connection.close();
    }

    private class ConsumerThread
    extends Thread {
        private ConsumerThread() {
        }

        @Override
        public void run() {
            try {
                long currentSendCount;
                TransactedStoreUsageSuspendResumeTest.this.consumerStartLatch.await(30L, TimeUnit.SECONDS);
                ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://localhost");
                Connection connection = factory.createConnection();
                connection.start();
                Session session = connection.createSession(true, 0);
                do {
                    currentSendCount = TransactedStoreUsageSuspendResumeTest.this.messagesSentCountDown.getCount();
                    TimeUnit.SECONDS.sleep(5L);
                } while (currentSendCount != TransactedStoreUsageSuspendResumeTest.this.messagesSentCountDown.getCount());
                LOG.info("Starting consumer at: " + currentSendCount);
                MessageConsumer consumer = session.createConsumer((Destination)session.createQueue(TransactedStoreUsageSuspendResumeTest.QUEUE_NAME));
                do {
                    Message message;
                    if ((message = consumer.receive(1000L)) != null) {
                        session.commit();
                        TransactedStoreUsageSuspendResumeTest.this.messagesReceivedCountDown.countDown();
                    }
                    if (TransactedStoreUsageSuspendResumeTest.this.messagesReceivedCountDown.getCount() % 500L != 0L) continue;
                    LOG.info("remaining to receive: " + TransactedStoreUsageSuspendResumeTest.this.messagesReceivedCountDown.getCount());
                } while (TransactedStoreUsageSuspendResumeTest.this.messagesReceivedCountDown.getCount() != 0L);
                consumer.close();
                session.close();
                connection.close();
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
            }
        }
    }
}

