/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.proxy;

import java.net.URI;
import java.util.ArrayList;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSSecurityException;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerPlugin;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.proxy.ProxyConnector;
import org.apache.activemq.security.AuthenticationUser;
import org.apache.activemq.security.SimpleAuthenticationPlugin;
import org.apache.activemq.util.Wait;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ4889Test {
    protected static final Logger LOG = LoggerFactory.getLogger(AMQ4889Test.class);
    public static final String USER = "user";
    public static final String GOOD_USER_PASSWORD = "password";
    public static final String WRONG_PASSWORD = "wrongPassword";
    public static final String PROXY_URI = "tcp://localhost:6002";
    public static final String LOCAL_URI = "tcp://localhost:6001";
    protected BrokerService brokerService;
    private ProxyConnector proxyConnector;
    protected TransportConnector transportConnector;
    protected ConnectionFactory connectionFactory;
    private static final Integer ITERATIONS = 100;

    protected BrokerService createBroker() throws Exception {
        this.brokerService = new BrokerService();
        this.brokerService.setPersistent(false);
        ArrayList<BrokerPlugin> plugins = new ArrayList<BrokerPlugin>();
        BrokerPlugin authenticationPlugin = this.configureAuthentication();
        plugins.add(authenticationPlugin);
        BrokerPlugin[] array = new BrokerPlugin[plugins.size()];
        this.brokerService.setPlugins(plugins.toArray(array));
        this.transportConnector = this.brokerService.addConnector(LOCAL_URI);
        this.proxyConnector = new ProxyConnector();
        this.proxyConnector.setName("proxy");
        this.proxyConnector.setBind(new URI(PROXY_URI));
        this.proxyConnector.setRemote(new URI(LOCAL_URI));
        this.brokerService.addProxyConnector(this.proxyConnector);
        this.brokerService.start();
        this.brokerService.waitUntilStarted();
        return this.brokerService;
    }

    protected BrokerPlugin configureAuthentication() throws Exception {
        ArrayList<AuthenticationUser> users = new ArrayList<AuthenticationUser>();
        users.add(new AuthenticationUser(USER, GOOD_USER_PASSWORD, "users"));
        SimpleAuthenticationPlugin authenticationPlugin = new SimpleAuthenticationPlugin(users);
        return authenticationPlugin;
    }

    @Before
    public void setUp() throws Exception {
        this.brokerService = this.createBroker();
        this.connectionFactory = new ActiveMQConnectionFactory(PROXY_URI);
    }

    @After
    public void tearDown() throws Exception {
        this.brokerService.stop();
        this.brokerService.waitUntilStopped();
    }

    @Test(timeout=60000L)
    public void testForConnectionLeak() throws Exception {
        Integer expectedConnectionCount = 0;
        for (int i = 0; i < ITERATIONS; ++i) {
            try {
                Session session;
                Connection connection;
                if (i % 2 == 0) {
                    LOG.debug("Iteration {} adding bad connection", (Object)i);
                    connection = this.connectionFactory.createConnection(USER, WRONG_PASSWORD);
                    session = connection.createSession(false, 1);
                    Assert.fail((String)"createSession should fail");
                } else {
                    LOG.debug("Iteration {} adding good connection", (Object)i);
                    connection = this.connectionFactory.createConnection(USER, GOOD_USER_PASSWORD);
                    session = connection.createSession(false, 1);
                    Integer n = expectedConnectionCount;
                    Integer n2 = expectedConnectionCount = Integer.valueOf(expectedConnectionCount + 1);
                }
            }
            catch (JMSSecurityException jMSSecurityException) {
                // empty catch block
            }
            LOG.debug("Iteration {} Connections? {}", (Object)i, (Object)this.proxyConnector.getConnectionCount());
        }
        final Integer val = expectedConnectionCount;
        Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return val.equals(AMQ4889Test.this.proxyConnector.getConnectionCount());
            }
        }, (long)20L);
        Assert.assertEquals((Object)val, (Object)this.proxyConnector.getConnectionCount());
    }
}

