/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.jdbc;

import java.io.PrintWriter;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.sql.DataSource;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.Locker;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.jdbc.JDBCIOExceptionHandler;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.apache.activemq.store.jdbc.LeaseDatabaseLocker;
import org.apache.activemq.util.IOExceptionHandler;
import org.apache.derby.jdbc.EmbeddedDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCIOExceptionHandlerTest
extends TestCase {
    private static final Logger LOG = LoggerFactory.getLogger(JDBCIOExceptionHandlerTest.class);
    private static final String TRANSPORT_URL = "tcp://0.0.0.0:0";
    private ActiveMQConnectionFactory factory;
    private ReconnectingEmbeddedDataSource dataSource;
    private BrokerService broker;

    protected BrokerService createBroker(boolean withJMX) throws Exception {
        BrokerService broker = new BrokerService();
        broker.setUseJmx(withJMX);
        EmbeddedDataSource embeddedDataSource = new EmbeddedDataSource();
        embeddedDataSource.setDatabaseName("derbydb_15");
        embeddedDataSource.setCreateDatabase("create");
        this.dataSource = new ReconnectingEmbeddedDataSource(embeddedDataSource);
        JDBCPersistenceAdapter jdbc = new JDBCPersistenceAdapter();
        jdbc.setDataSource((DataSource)this.dataSource);
        jdbc.setLockKeepAlivePeriod(1000L);
        LeaseDatabaseLocker leaseDatabaseLocker = new LeaseDatabaseLocker();
        leaseDatabaseLocker.setLockAcquireSleepInterval(2000L);
        jdbc.setLocker((Locker)leaseDatabaseLocker);
        broker.setPersistenceAdapter((PersistenceAdapter)jdbc);
        JDBCIOExceptionHandler jdbcioExceptionHandler = new JDBCIOExceptionHandler();
        jdbcioExceptionHandler.setResumeCheckSleepPeriod(1000L);
        broker.setIoExceptionHandler((IOExceptionHandler)jdbcioExceptionHandler);
        String connectionUri = broker.addConnector(TRANSPORT_URL).getPublishableConnectString();
        this.factory = new ActiveMQConnectionFactory(connectionUri);
        return broker;
    }

    public void testRecoverWithOutJMX() throws Exception {
        this.recoverFromDisconnectDB(false);
    }

    public void testRecoverWithJMX() throws Exception {
        this.recoverFromDisconnectDB(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recoverFromDisconnectDB(boolean withJMX) throws Exception {
        try {
            this.broker = this.createBroker(withJMX);
            this.broker.start();
            this.broker.waitUntilStarted();
            this.dataSource.stopDB();
            TimeUnit.SECONDS.sleep(3L);
            this.checkTransportConnectorStopped();
            this.dataSource.restartDB();
            LOG.debug("*** Waiting for connector to start...");
            TimeUnit.SECONDS.sleep(3L);
            LOG.debug("*** checking connector to start...");
            this.checkTransportConnectorStarted();
        }
        finally {
            LOG.debug("*** broker is stopping...");
            this.broker.stop();
        }
    }

    private void checkTransportConnectorStopped() {
        try {
            this.factory.createConnection();
            JDBCIOExceptionHandlerTest.fail((String)"Transport connector should be stopped");
        }
        catch (Exception ex) {
            LOG.debug(" checkTransportConnectorStopped() threw", (Throwable)ex);
        }
    }

    private void checkTransportConnectorStarted() {
        try {
            Connection conn = this.factory.createConnection();
            conn.close();
        }
        catch (Exception ex) {
            LOG.debug("checkTransportConnectorStarted() threw", (Throwable)ex);
            JDBCIOExceptionHandlerTest.fail((String)"Transport connector should have been started");
        }
    }

    public class ReconnectingEmbeddedDataSource
    implements DataSource {
        private EmbeddedDataSource realDatasource;

        public ReconnectingEmbeddedDataSource(EmbeddedDataSource datasource) {
            this.realDatasource = datasource;
        }

        @Override
        public PrintWriter getLogWriter() throws SQLException {
            return this.realDatasource.getLogWriter();
        }

        @Override
        public void setLogWriter(PrintWriter out) throws SQLException {
            this.realDatasource.setLogWriter(out);
        }

        @Override
        public void setLoginTimeout(int seconds) throws SQLException {
            this.realDatasource.setLoginTimeout(seconds);
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            return this.realDatasource.getLoginTimeout();
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            return this.unwrap(iface);
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return this.isWrapperFor(iface);
        }

        @Override
        public java.sql.Connection getConnection() throws SQLException {
            return this.realDatasource.getConnection();
        }

        @Override
        public java.sql.Connection getConnection(String username, String password) throws SQLException {
            return this.getConnection(username, password);
        }

        public void restartDB() throws SQLException {
            EmbeddedDataSource newDatasource = new EmbeddedDataSource();
            newDatasource.setDatabaseName(this.realDatasource.getDatabaseName());
            newDatasource.getConnection();
            LOG.info("*** DB restarted now...");
            this.realDatasource = newDatasource;
        }

        public void stopDB() {
            try {
                this.realDatasource.setShutdownDatabase("shutdown");
                LOG.info("***DB is being shutdown...");
                JDBCIOExceptionHandlerTest.this.dataSource.getConnection();
                TestCase.fail((String)"should have thrown a db closed exception");
            }
            catch (Exception ex) {
                ex.printStackTrace(System.out);
            }
        }

        @Override
        public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
            return null;
        }
    }
}

