/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.nio;

import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.util.Wait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NIOSSLConcurrencyTest
extends TestCase {
    BrokerService broker;
    Connection connection;
    public static final String KEYSTORE_TYPE = "jks";
    public static final String PASSWORD = "password";
    public static final String SERVER_KEYSTORE = "src/test/resources/server.keystore";
    public static final String TRUST_KEYSTORE = "src/test/resources/client.keystore";
    public static final int PRODUCER_COUNT = 10;
    public static final int CONSUMER_COUNT = 10;
    public static final int MESSAGE_COUNT = 10000;
    public static final int MESSAGE_SIZE = 4096;
    final ConsumerThread[] consumers = new ConsumerThread[10];
    final Session[] producerSessions = new Session[10];
    final Session[] consumerSessions = new Session[10];
    byte[] messageData;
    volatile boolean failed;

    protected void setUp() throws Exception {
        int i;
        System.setProperty("javax.net.ssl.trustStore", TRUST_KEYSTORE);
        System.setProperty("javax.net.ssl.trustStorePassword", PASSWORD);
        System.setProperty("javax.net.ssl.trustStoreType", KEYSTORE_TYPE);
        System.setProperty("javax.net.ssl.keyStore", SERVER_KEYSTORE);
        System.setProperty("javax.net.ssl.keyStoreType", KEYSTORE_TYPE);
        System.setProperty("javax.net.ssl.keyStorePassword", PASSWORD);
        this.broker = new BrokerService();
        this.broker.setPersistent(false);
        this.broker.setUseJmx(false);
        TransportConnector connector = this.broker.addConnector("nio+ssl://localhost:0?transport.needClientAuth=true&transport.enabledCipherSuites=SSL_RSA_WITH_RC4_128_SHA,SSL_DH_anon_WITH_3DES_EDE_CBC_SHA");
        this.broker.start();
        this.broker.waitUntilStarted();
        this.failed = false;
        this.messageData = new byte[4096];
        for (int i2 = 0; i2 < 4096; ++i2) {
            this.messageData[i2] = (byte)(i2 & 0xFF);
        }
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("nio+ssl://localhost:" + connector.getConnectUri().getPort());
        this.connection = factory.createConnection();
        for (i = 0; i < 10; ++i) {
            this.producerSessions[i] = this.connection.createSession(false, 1);
        }
        for (i = 0; i < 10; ++i) {
            this.consumerSessions[i] = this.connection.createSession(false, 1);
        }
        this.connection.start();
    }

    protected void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
        if (this.broker != null) {
            this.broker.stop();
            this.broker.waitUntilStopped();
        }
    }

    public void testLoad() throws Exception {
        Queue dest;
        int i;
        for (i = 0; i < 10; ++i) {
            dest = this.producerSessions[i].createQueue("TEST" + i);
            ProducerThread producer = new ProducerThread(this.producerSessions[i], (Destination)dest);
            producer.setMessageCount(10000);
            producer.start();
        }
        for (i = 0; i < 10; ++i) {
            dest = this.consumerSessions[i].createQueue("TEST" + i);
            ConsumerThread consumer = new ConsumerThread(this.consumerSessions[i], (Destination)dest);
            consumer.setMessageCount(10000);
            consumer.start();
            this.consumers[i] = consumer;
        }
        Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return NIOSSLConcurrencyTest.this.failed || NIOSSLConcurrencyTest.this.getReceived() == 100000;
            }
        }, (long)120000L);
        NIOSSLConcurrencyTest.assertEquals((int)100000, (int)this.getReceived());
    }

    protected int getReceived() {
        int received = 0;
        for (ConsumerThread consumer : this.consumers) {
            received += consumer.getReceived();
        }
        return received;
    }

    private class ProducerThread
    extends Thread {
        private final Logger LOG = LoggerFactory.getLogger(ProducerThread.class);
        int messageCount = 1000;
        Destination dest;
        protected Session sess;
        int sleep = 0;
        int sentCount = 0;

        public ProducerThread(Session sess, Destination dest) {
            this.dest = dest;
            this.sess = sess;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            MessageProducer producer = null;
            try {
                producer = this.sess.createProducer(this.dest);
                this.sentCount = 0;
                while (this.sentCount < this.messageCount) {
                    producer.send(this.createMessage(this.sentCount));
                    this.LOG.info("Sent 'test message: " + this.sentCount + "'");
                    if (this.sleep > 0) {
                        Thread.sleep(this.sleep);
                    }
                    ++this.sentCount;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                NIOSSLConcurrencyTest.this.failed = true;
            }
            finally {
                if (producer != null) {
                    try {
                        producer.close();
                    }
                    catch (JMSException e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        protected Message createMessage(int i) throws Exception {
            BytesMessage b = this.sess.createBytesMessage();
            b.writeBytes(NIOSSLConcurrencyTest.this.messageData);
            return b;
        }

        public void setMessageCount(int messageCount) {
            this.messageCount = messageCount;
        }
    }

    private class ConsumerThread
    extends Thread {
        private final Logger LOG = LoggerFactory.getLogger(ConsumerThread.class);
        int messageCount = 1000;
        int received = 0;
        Destination dest;
        Session sess;
        boolean breakOnNull = true;

        public ConsumerThread(Session sess, Destination dest) {
            this.dest = dest;
            this.sess = sess;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            MessageConsumer consumer = null;
            try {
                consumer = this.sess.createConsumer(this.dest);
                while (this.received < this.messageCount) {
                    Message msg = consumer.receive(3000L);
                    if (msg != null) {
                        this.LOG.info("Received test message: " + this.received++);
                        continue;
                    }
                    if (!this.breakOnNull) continue;
                    break;
                }
            }
            catch (JMSException e) {
                e.printStackTrace();
                NIOSSLConcurrencyTest.this.failed = true;
            }
            finally {
                if (consumer != null) {
                    try {
                        consumer.close();
                    }
                    catch (JMSException e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        public int getReceived() {
            return this.received;
        }

        public void setMessageCount(int messageCount) {
            this.messageCount = messageCount;
        }
    }
}

