/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.web.controller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.apache.activemq.web.BrokerFacade;
import org.apache.activemq.web.DestinationFacade;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

public class DeleteMessage
extends DestinationFacade
implements Controller {
    private String messageId;

    public DeleteMessage(BrokerFacade brokerFacade) {
        super(brokerFacade);
    }

    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.messageId != null) {
            QueueViewMBean queueView = this.getQueue();
            if (queueView != null) {
                System.out.println("#### removing message: " + this.messageId);
                queueView.removeMessage(this.messageId);
            } else {
                System.out.println("#### NO QUEUE!");
            }
        }
        return this.redirectToBrowseView();
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    protected QueueViewMBean getQueue() throws Exception {
        String name = this.getPhysicalDestinationName();
        System.out.println("####\u00calooking up queue: " + name);
        return this.getBrokerFacade().getQueue(name);
    }
}

