/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.web;

import javax.servlet.http.HttpServletRequest;
import org.apache.activemq.broker.jmx.BrokerViewMBean;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.web.BrokerFacade;
import org.springframework.web.servlet.ModelAndView;

public class DestinationFacade {
    private String jmsDestination;
    private String jmsDestinationType;
    private BrokerFacade brokerFacade;

    public DestinationFacade(BrokerFacade brokerFacade) {
        this.brokerFacade = brokerFacade;
    }

    public String toString() {
        return super.toString() + "[destination:" + this.jmsDestination + "; type=" + this.jmsDestinationType + "]";
    }

    public void removeDestination() throws Exception {
        this.getValidDestination();
        if (this.isQueue()) {
            this.getBrokerAdmin().removeQueue(this.getJMSDestination());
        } else {
            this.getBrokerAdmin().removeTopic(this.getJMSDestination());
        }
    }

    public void addDestination() throws Exception {
        if (this.isQueue()) {
            this.getBrokerAdmin().addQueue(this.getValidDestination());
        } else {
            this.getBrokerAdmin().addTopic(this.getValidDestination());
        }
    }

    public BrokerViewMBean getBrokerAdmin() throws Exception {
        return this.brokerFacade.getBrokerAdmin();
    }

    public BrokerFacade getBrokerFacade() {
        return this.brokerFacade;
    }

    public boolean isQueue() {
        return this.jmsDestinationType == null || !this.jmsDestinationType.equalsIgnoreCase("topic");
    }

    public String getJMSDestination() {
        return this.jmsDestination;
    }

    public void setJMSDestination(String destination) {
        this.jmsDestination = destination;
    }

    public String getJMSDestinationType() {
        return this.jmsDestinationType;
    }

    public void setJMSDestinationType(String type) {
        this.jmsDestinationType = type;
    }

    protected ActiveMQDestination createDestination() {
        byte destinationType = this.isQueue() ? (byte)1 : 2;
        return ActiveMQDestination.createDestination((String)this.getValidDestination(), (byte)destinationType);
    }

    protected String getValidDestination() {
        if (this.jmsDestination == null) {
            throw new IllegalArgumentException("No JMSDestination parameter specified");
        }
        return this.jmsDestination;
    }

    protected ModelAndView redirectToRequest(HttpServletRequest request) {
        String view = "redirect:" + request.getRequestURI();
        return new ModelAndView(view);
    }

    protected ModelAndView redirectToBrowseView() {
        return new ModelAndView("redirect:" + (this.isQueue() ? "queues.jsp" : "topics.jsp"));
    }

    protected String getPhysicalDestinationName() {
        return this.createDestination().getPhysicalName();
    }
}

