/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.shiro.subject;

import java.security.Principal;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.security.SecurityContext;
import org.apache.activemq.shiro.subject.SubjectConnectionReference;
import org.apache.shiro.subject.Subject;

public class SubjectSecurityContext
extends SecurityContext {
    private final Subject subject;

    public SubjectSecurityContext(SubjectConnectionReference conn) {
        super(null);
        this.subject = conn.getSubject();
    }

    public Subject getSubject() {
        return this.subject;
    }

    private static String getUsername(Subject subject) {
        Object principal;
        if (subject != null && (principal = subject.getPrincipal()) != null) {
            return String.valueOf(principal);
        }
        return null;
    }

    public String getUserName() {
        return SubjectSecurityContext.getUsername(this.subject);
    }

    private static UnsupportedOperationException notAllowed(String methodName) {
        String msg = "Do not invoke the '" + methodName + "' method or use a broker filter that invokes it.  Use one " + "of the Shiro-based security filters instead.";
        return new UnsupportedOperationException(msg);
    }

    public boolean isInOneOf(Set<?> allowedPrincipals) {
        throw SubjectSecurityContext.notAllowed("isInOneOf");
    }

    public ConcurrentHashMap<ActiveMQDestination, ActiveMQDestination> getAuthorizedReadDests() {
        throw SubjectSecurityContext.notAllowed("getAuthorizedReadDests");
    }

    public ConcurrentHashMap<ActiveMQDestination, ActiveMQDestination> getAuthorizedWriteDests() {
        throw SubjectSecurityContext.notAllowed("getAuthorizedWriteDests");
    }

    public Set<Principal> getPrincipals() {
        throw SubjectSecurityContext.notAllowed("getPrincipals");
    }
}

