/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.pool;

import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.XAConnection;
import javax.jms.XASession;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.transaction.xa.XAResource;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQSession;
import org.apache.activemq.ActiveMQXAConnectionFactory;
import org.apache.activemq.Service;
import org.apache.activemq.jms.pool.ConnectionPool;
import org.apache.activemq.jms.pool.PooledSession;
import org.apache.activemq.jms.pool.SessionKey;
import org.apache.activemq.jms.pool.XaConnectionPool;
import org.apache.activemq.jndi.JNDIReferenceFactory;
import org.apache.activemq.jndi.JNDIStorableInterface;
import org.apache.activemq.transport.TransportListener;
import org.apache.activemq.util.IntrospectionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XaPooledConnectionFactory
extends org.apache.activemq.jms.pool.XaPooledConnectionFactory
implements JNDIStorableInterface,
Service {
    public static final String POOL_PROPS_PREFIX = "pool";
    private static final transient Logger LOG = LoggerFactory.getLogger(org.apache.activemq.jms.pool.XaPooledConnectionFactory.class);
    private String brokerUrl;

    public XaPooledConnectionFactory() {
    }

    public XaPooledConnectionFactory(ActiveMQXAConnectionFactory connectionFactory) {
        this.setConnectionFactory(connectionFactory);
    }

    @Override
    protected ConnectionPool createConnectionPool(Connection connection) {
        return new XaConnectionPool(connection, this.getTransactionManager()){

            @Override
            protected Session makeSession(SessionKey key) throws JMSException {
                if (this.connection instanceof XAConnection) {
                    return ((XAConnection)this.connection).createXASession();
                }
                return this.connection.createSession(key.isTransacted(), key.getAckMode());
            }

            @Override
            protected XAResource createXaResource(PooledSession session) throws JMSException {
                if (session.getInternalSession() instanceof XASession) {
                    return ((XASession)session.getInternalSession()).getXAResource();
                }
                return ((ActiveMQSession)session.getInternalSession()).getTransactionContext();
            }

            @Override
            protected Connection wrap(final Connection connection) {
                ((ActiveMQConnection)connection).addTransportListener(new TransportListener(){

                    @Override
                    public void onCommand(Object command) {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onException(IOException error) {
                        1 var2_2 = this;
                        synchronized (var2_2) {
                            this.setHasExpired(true);
                            LOG.info("Expiring connection " + connection + " on IOException: " + error);
                            LOG.debug("Expiring connection on IOException", error);
                        }
                    }

                    @Override
                    public void transportInterupted() {
                    }

                    @Override
                    public void transportResumed() {
                    }
                });
                this.setHasExpired(((ActiveMQConnection)connection).isTransportFailed());
                return connection;
            }

            @Override
            protected void unWrap(Connection connection) {
                if (connection != null) {
                    ((ActiveMQConnection)connection).cleanUpTempDestinations();
                }
            }
        };
    }

    protected void buildFromProperties(Properties props) {
        ActiveMQConnectionFactory activeMQConnectionFactory = props.containsKey("xaAckMode") ? new ActiveMQXAConnectionFactory() : new ActiveMQConnectionFactory();
        activeMQConnectionFactory.buildFromProperties(props);
        this.setConnectionFactory(activeMQConnectionFactory);
        IntrospectionSupport.setProperties(this, new HashMap<Object, Object>(props), POOL_PROPS_PREFIX);
    }

    @Override
    protected void populateProperties(Properties props) {
        ((ActiveMQConnectionFactory)this.getConnectionFactory()).populateProperties(props);
        IntrospectionSupport.getProperties(this, props, POOL_PROPS_PREFIX);
    }

    @Override
    public void setProperties(Properties properties) {
        this.buildFromProperties(properties);
    }

    @Override
    public Properties getProperties() {
        Properties properties = new Properties();
        this.populateProperties(properties);
        return properties;
    }

    @Override
    public Reference getReference() throws NamingException {
        return JNDIReferenceFactory.createReference(this.getClass().getName(), this);
    }

    public void setBrokerUrl(String url) {
        if (this.brokerUrl == null || !this.brokerUrl.equals(url)) {
            this.brokerUrl = url;
            this.setConnectionFactory(new ActiveMQXAConnectionFactory(this.brokerUrl));
        }
    }

    public String getBrokerUrl() {
        return this.brokerUrl;
    }
}

