/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.mqtt;

import java.util.HashSet;
import java.util.Set;
import org.apache.activemq.Service;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.filter.DestinationMapNode;
import org.apache.activemq.util.ServiceStopper;
import org.apache.activemq.util.ServiceSupport;
import org.fusesource.mqtt.codec.PUBLISH;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQTTRetainedMessages
extends ServiceSupport {
    private static final Logger LOG = LoggerFactory.getLogger(MQTTRetainedMessages.class);
    private static final Object LOCK = new Object();
    DestinationMapNode retainedMessages = new DestinationMapNode(null);

    private MQTTRetainedMessages() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStop(ServiceStopper stopper) throws Exception {
        MQTTRetainedMessages mQTTRetainedMessages = this;
        synchronized (mQTTRetainedMessages) {
            this.retainedMessages = new DestinationMapNode(null);
        }
    }

    @Override
    protected void doStart() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessage(ActiveMQTopic dest, PUBLISH publish) {
        MQTTRetainedMessages mQTTRetainedMessages = this;
        synchronized (mQTTRetainedMessages) {
            this.retainedMessages.set(dest.getDestinationPaths(), 0, publish);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<PUBLISH> getMessages(ActiveMQTopic topic) {
        HashSet<PUBLISH> answer = new HashSet<PUBLISH>();
        MQTTRetainedMessages mQTTRetainedMessages = this;
        synchronized (mQTTRetainedMessages) {
            this.retainedMessages.appendMatchingValues(answer, topic.getDestinationPaths(), 0);
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MQTTRetainedMessages getMQTTRetainedMessages(BrokerService broker) {
        MQTTRetainedMessages result = null;
        if (broker != null) {
            Object object = LOCK;
            synchronized (object) {
                Service[] services = broker.getServices();
                if (services != null) {
                    for (Service service : services) {
                        if (!(service instanceof MQTTRetainedMessages)) continue;
                        return (MQTTRetainedMessages)service;
                    }
                }
                result = new MQTTRetainedMessages();
                broker.addService(result);
                if (broker != null && broker.isStarted()) {
                    try {
                        result.start();
                    }
                    catch (Exception e) {
                        LOG.warn("Couldn't start MQTTRetainedMessages");
                    }
                }
            }
        }
        return result;
    }
}

